// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The assignment of a control set to a delegate for review.
 */
class Delegation private constructor(builder: BuilderImpl) {
    /**
     * The identifier for the associated assessment.
     */
    val assessmentId: String? = builder.assessmentId
    /**
     * The name of the associated assessment.
     */
    val assessmentName: String? = builder.assessmentName
    /**
     * The comment related to the delegation.
     */
    val comment: String? = builder.comment
    /**
     * The identifier for the associated control set.
     */
    val controlSetId: String? = builder.controlSetId
    /**
     * The IAM user or role that created the delegation.
     */
    val createdBy: String? = builder.createdBy
    /**
     * Specifies when the delegation was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The unique identifier for the delegation.
     */
    val id: String? = builder.id
    /**
     * Specifies when the delegation was last updated.
     */
    val lastUpdated: Instant? = builder.lastUpdated
    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The type of customer persona.
     * In CreateAssessment, roleType can only be PROCESS_OWNER.
     * In UpdateSettings, roleType can only be PROCESS_OWNER.
     * In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
     */
    val roleType: RoleType? = builder.roleType
    /**
     * The status of the delegation.
     */
    val status: DelegationStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Delegation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Delegation(")
        append("assessmentId=$assessmentId,")
        append("assessmentName=$assessmentName,")
        append("comment=$comment,")
        append("controlSetId=$controlSetId,")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("id=$id,")
        append("lastUpdated=$lastUpdated,")
        append("roleArn=$roleArn,")
        append("roleType=$roleType,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentId?.hashCode() ?: 0
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (controlSetId?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (roleType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Delegation

        if (assessmentId != other.assessmentId) return false
        if (assessmentName != other.assessmentName) return false
        if (comment != other.comment) return false
        if (controlSetId != other.controlSetId) return false
        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (id != other.id) return false
        if (lastUpdated != other.lastUpdated) return false
        if (roleArn != other.roleArn) return false
        if (roleType != other.roleType) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Delegation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Delegation
        /**
         * The identifier for the associated assessment.
         */
        fun assessmentId(assessmentId: String): FluentBuilder
        /**
         * The name of the associated assessment.
         */
        fun assessmentName(assessmentName: String): FluentBuilder
        /**
         * The comment related to the delegation.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * The identifier for the associated control set.
         */
        fun controlSetId(controlSetId: String): FluentBuilder
        /**
         * The IAM user or role that created the delegation.
         */
        fun createdBy(createdBy: String): FluentBuilder
        /**
         * Specifies when the delegation was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The unique identifier for the delegation.
         */
        fun id(id: String): FluentBuilder
        /**
         * Specifies when the delegation was last updated.
         */
        fun lastUpdated(lastUpdated: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The type of customer persona.
         * In CreateAssessment, roleType can only be PROCESS_OWNER.
         * In UpdateSettings, roleType can only be PROCESS_OWNER.
         * In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
         */
        fun roleType(roleType: RoleType): FluentBuilder
        /**
         * The status of the delegation.
         */
        fun status(status: DelegationStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier for the associated assessment.
         */
        var assessmentId: String?
        /**
         * The name of the associated assessment.
         */
        var assessmentName: String?
        /**
         * The comment related to the delegation.
         */
        var comment: String?
        /**
         * The identifier for the associated control set.
         */
        var controlSetId: String?
        /**
         * The IAM user or role that created the delegation.
         */
        var createdBy: String?
        /**
         * Specifies when the delegation was created.
         */
        var creationTime: Instant?
        /**
         * The unique identifier for the delegation.
         */
        var id: String?
        /**
         * Specifies when the delegation was last updated.
         */
        var lastUpdated: Instant?
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        var roleArn: String?
        /**
         * The type of customer persona.
         * In CreateAssessment, roleType can only be PROCESS_OWNER.
         * In UpdateSettings, roleType can only be PROCESS_OWNER.
         * In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
         */
        var roleType: RoleType?
        /**
         * The status of the delegation.
         */
        var status: DelegationStatus?

        fun build(): Delegation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assessmentId: String? = null
        override var assessmentName: String? = null
        override var comment: String? = null
        override var controlSetId: String? = null
        override var createdBy: String? = null
        override var creationTime: Instant? = null
        override var id: String? = null
        override var lastUpdated: Instant? = null
        override var roleArn: String? = null
        override var roleType: RoleType? = null
        override var status: DelegationStatus? = null

        constructor(x: Delegation) : this() {
            this.assessmentId = x.assessmentId
            this.assessmentName = x.assessmentName
            this.comment = x.comment
            this.controlSetId = x.controlSetId
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.id = x.id
            this.lastUpdated = x.lastUpdated
            this.roleArn = x.roleArn
            this.roleType = x.roleType
            this.status = x.status
        }

        override fun build(): Delegation = Delegation(this)
        override fun assessmentId(assessmentId: String): FluentBuilder = apply { this.assessmentId = assessmentId }
        override fun assessmentName(assessmentName: String): FluentBuilder = apply { this.assessmentName = assessmentName }
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun controlSetId(controlSetId: String): FluentBuilder = apply { this.controlSetId = controlSetId }
        override fun createdBy(createdBy: String): FluentBuilder = apply { this.createdBy = createdBy }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdated(lastUpdated: Instant): FluentBuilder = apply { this.lastUpdated = lastUpdated }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun roleType(roleType: RoleType): FluentBuilder = apply { this.roleType = roleType }
        override fun status(status: DelegationStatus): FluentBuilder = apply { this.status = status }
    }
}
