// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * A collection of attributes used to create a delegation for an assessment in Audit Manager.
 */
class CreateDelegationRequest private constructor(builder: BuilderImpl) {
    /**
     * A comment related to the delegation request.
     */
    val comment: String? = builder.comment
    /**
     * The unique identifier for the control set.
     */
    val controlSetId: String? = builder.controlSetId
    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The type of customer persona.
     * In CreateAssessment, roleType can only be PROCESS_OWNER.
     * In UpdateSettings, roleType can only be PROCESS_OWNER.
     * In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
     */
    val roleType: RoleType? = builder.roleType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDelegationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDelegationRequest(")
        append("comment=$comment,")
        append("controlSetId=$controlSetId,")
        append("roleArn=$roleArn,")
        append("roleType=$roleType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (controlSetId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (roleType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDelegationRequest

        if (comment != other.comment) return false
        if (controlSetId != other.controlSetId) return false
        if (roleArn != other.roleArn) return false
        if (roleType != other.roleType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDelegationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDelegationRequest
        /**
         * A comment related to the delegation request.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * The unique identifier for the control set.
         */
        fun controlSetId(controlSetId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The type of customer persona.
         * In CreateAssessment, roleType can only be PROCESS_OWNER.
         * In UpdateSettings, roleType can only be PROCESS_OWNER.
         * In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
         */
        fun roleType(roleType: RoleType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A comment related to the delegation request.
         */
        var comment: String?
        /**
         * The unique identifier for the control set.
         */
        var controlSetId: String?
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        var roleArn: String?
        /**
         * The type of customer persona.
         * In CreateAssessment, roleType can only be PROCESS_OWNER.
         * In UpdateSettings, roleType can only be PROCESS_OWNER.
         * In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
         */
        var roleType: RoleType?

        fun build(): CreateDelegationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var comment: String? = null
        override var controlSetId: String? = null
        override var roleArn: String? = null
        override var roleType: RoleType? = null

        constructor(x: CreateDelegationRequest) : this() {
            this.comment = x.comment
            this.controlSetId = x.controlSetId
            this.roleArn = x.roleArn
            this.roleType = x.roleType
        }

        override fun build(): CreateDelegationRequest = CreateDelegationRequest(this)
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun controlSetId(controlSetId: String): FluentBuilder = apply { this.controlSetId = controlSetId }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun roleType(roleType: RoleType): FluentBuilder = apply { this.roleType = roleType }
    }
}
