// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



class CreateControlRequest private constructor(builder: BuilderImpl) {
    /**
     * The recommended actions to carry out if the control is not fulfilled.
     */
    val actionPlanInstructions: String? = builder.actionPlanInstructions
    /**
     * The title of the action plan for remediating the control.
     */
    val actionPlanTitle: String? = builder.actionPlanTitle
    /**
     * The data mapping sources for the specified control.
     */
    val controlMappingSources: List<CreateControlMappingSource>? = builder.controlMappingSources
    /**
     * The description of the control.
     */
    val description: String? = builder.description
    /**
     * The name of the control.
     */
    val name: String? = builder.name
    /**
     * The tags associated with the control.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The steps to follow to determine if the control has been satisfied.
     */
    val testingInformation: String? = builder.testingInformation

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateControlRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateControlRequest(")
        append("actionPlanInstructions=$actionPlanInstructions,")
        append("actionPlanTitle=$actionPlanTitle,")
        append("controlMappingSources=$controlMappingSources,")
        append("description=$description,")
        append("name=$name,")
        append("tags=$tags,")
        append("testingInformation=$testingInformation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionPlanInstructions?.hashCode() ?: 0
        result = 31 * result + (actionPlanTitle?.hashCode() ?: 0)
        result = 31 * result + (controlMappingSources?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (testingInformation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateControlRequest

        if (actionPlanInstructions != other.actionPlanInstructions) return false
        if (actionPlanTitle != other.actionPlanTitle) return false
        if (controlMappingSources != other.controlMappingSources) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (testingInformation != other.testingInformation) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateControlRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateControlRequest
        /**
         * The recommended actions to carry out if the control is not fulfilled.
         */
        fun actionPlanInstructions(actionPlanInstructions: String): FluentBuilder
        /**
         * The title of the action plan for remediating the control.
         */
        fun actionPlanTitle(actionPlanTitle: String): FluentBuilder
        /**
         * The data mapping sources for the specified control.
         */
        fun controlMappingSources(controlMappingSources: List<CreateControlMappingSource>): FluentBuilder
        /**
         * The description of the control.
         */
        fun description(description: String): FluentBuilder
        /**
         * The name of the control.
         */
        fun name(name: String): FluentBuilder
        /**
         * The tags associated with the control.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The steps to follow to determine if the control has been satisfied.
         */
        fun testingInformation(testingInformation: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The recommended actions to carry out if the control is not fulfilled.
         */
        var actionPlanInstructions: String?
        /**
         * The title of the action plan for remediating the control.
         */
        var actionPlanTitle: String?
        /**
         * The data mapping sources for the specified control.
         */
        var controlMappingSources: List<CreateControlMappingSource>?
        /**
         * The description of the control.
         */
        var description: String?
        /**
         * The name of the control.
         */
        var name: String?
        /**
         * The tags associated with the control.
         */
        var tags: Map<String, String>?
        /**
         * The steps to follow to determine if the control has been satisfied.
         */
        var testingInformation: String?

        fun build(): CreateControlRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actionPlanInstructions: String? = null
        override var actionPlanTitle: String? = null
        override var controlMappingSources: List<CreateControlMappingSource>? = null
        override var description: String? = null
        override var name: String? = null
        override var tags: Map<String, String>? = null
        override var testingInformation: String? = null

        constructor(x: CreateControlRequest) : this() {
            this.actionPlanInstructions = x.actionPlanInstructions
            this.actionPlanTitle = x.actionPlanTitle
            this.controlMappingSources = x.controlMappingSources
            this.description = x.description
            this.name = x.name
            this.tags = x.tags
            this.testingInformation = x.testingInformation
        }

        override fun build(): CreateControlRequest = CreateControlRequest(this)
        override fun actionPlanInstructions(actionPlanInstructions: String): FluentBuilder = apply { this.actionPlanInstructions = actionPlanInstructions }
        override fun actionPlanTitle(actionPlanTitle: String): FluentBuilder = apply { this.actionPlanTitle = actionPlanTitle }
        override fun controlMappingSources(controlMappingSources: List<CreateControlMappingSource>): FluentBuilder = apply { this.controlMappingSources = controlMappingSources }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun testingInformation(testingInformation: String): FluentBuilder = apply { this.testingInformation = testingInformation }
    }
}
