// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * Control mapping fields that represent the source for evidence collection, along with related parameters and metadata. This does not contain mappingID.
 */
class CreateControlMappingSource private constructor(builder: BuilderImpl) {
    /**
     * The description of the data source that determines from where Audit Manager collects evidence for the control.
     */
    val sourceDescription: String? = builder.sourceDescription
    /**
     * The frequency of evidence collection for the specified control mapping source.
     */
    val sourceFrequency: SourceFrequency? = builder.sourceFrequency
    /**
     * The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names.
     */
    val sourceKeyword: SourceKeyword? = builder.sourceKeyword
    /**
     * The name of the control mapping data source.
     */
    val sourceName: String? = builder.sourceName
    /**
     * The setup option for the data source, which reflects if the evidence collection is automated or manual.
     */
    val sourceSetUpOption: SourceSetUpOption? = builder.sourceSetUpOption
    /**
     * Specifies one of the five types of data sources for evidence collection.
     */
    val sourceType: SourceType? = builder.sourceType
    /**
     * The instructions for troubleshooting the specified control.
     */
    val troubleshootingText: String? = builder.troubleshootingText

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateControlMappingSource = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateControlMappingSource(")
        append("sourceDescription=$sourceDescription,")
        append("sourceFrequency=$sourceFrequency,")
        append("sourceKeyword=$sourceKeyword,")
        append("sourceName=$sourceName,")
        append("sourceSetUpOption=$sourceSetUpOption,")
        append("sourceType=$sourceType,")
        append("troubleshootingText=$troubleshootingText)")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceDescription?.hashCode() ?: 0
        result = 31 * result + (sourceFrequency?.hashCode() ?: 0)
        result = 31 * result + (sourceKeyword?.hashCode() ?: 0)
        result = 31 * result + (sourceName?.hashCode() ?: 0)
        result = 31 * result + (sourceSetUpOption?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (troubleshootingText?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateControlMappingSource

        if (sourceDescription != other.sourceDescription) return false
        if (sourceFrequency != other.sourceFrequency) return false
        if (sourceKeyword != other.sourceKeyword) return false
        if (sourceName != other.sourceName) return false
        if (sourceSetUpOption != other.sourceSetUpOption) return false
        if (sourceType != other.sourceType) return false
        if (troubleshootingText != other.troubleshootingText) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateControlMappingSource = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateControlMappingSource
        /**
         * The description of the data source that determines from where Audit Manager collects evidence for the control.
         */
        fun sourceDescription(sourceDescription: String): FluentBuilder
        /**
         * The frequency of evidence collection for the specified control mapping source.
         */
        fun sourceFrequency(sourceFrequency: SourceFrequency): FluentBuilder
        /**
         * The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names.
         */
        fun sourceKeyword(sourceKeyword: SourceKeyword): FluentBuilder
        /**
         * The name of the control mapping data source.
         */
        fun sourceName(sourceName: String): FluentBuilder
        /**
         * The setup option for the data source, which reflects if the evidence collection is automated or manual.
         */
        fun sourceSetUpOption(sourceSetUpOption: SourceSetUpOption): FluentBuilder
        /**
         * Specifies one of the five types of data sources for evidence collection.
         */
        fun sourceType(sourceType: SourceType): FluentBuilder
        /**
         * The instructions for troubleshooting the specified control.
         */
        fun troubleshootingText(troubleshootingText: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description of the data source that determines from where Audit Manager collects evidence for the control.
         */
        var sourceDescription: String?
        /**
         * The frequency of evidence collection for the specified control mapping source.
         */
        var sourceFrequency: SourceFrequency?
        /**
         * The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names.
         */
        var sourceKeyword: SourceKeyword?
        /**
         * The name of the control mapping data source.
         */
        var sourceName: String?
        /**
         * The setup option for the data source, which reflects if the evidence collection is automated or manual.
         */
        var sourceSetUpOption: SourceSetUpOption?
        /**
         * Specifies one of the five types of data sources for evidence collection.
         */
        var sourceType: SourceType?
        /**
         * The instructions for troubleshooting the specified control.
         */
        var troubleshootingText: String?

        fun build(): CreateControlMappingSource
        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.SourceKeyword] inside the given [block]
         */
        fun sourceKeyword(block: SourceKeyword.DslBuilder.() -> kotlin.Unit) {
            this.sourceKeyword = SourceKeyword.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var sourceDescription: String? = null
        override var sourceFrequency: SourceFrequency? = null
        override var sourceKeyword: SourceKeyword? = null
        override var sourceName: String? = null
        override var sourceSetUpOption: SourceSetUpOption? = null
        override var sourceType: SourceType? = null
        override var troubleshootingText: String? = null

        constructor(x: CreateControlMappingSource) : this() {
            this.sourceDescription = x.sourceDescription
            this.sourceFrequency = x.sourceFrequency
            this.sourceKeyword = x.sourceKeyword
            this.sourceName = x.sourceName
            this.sourceSetUpOption = x.sourceSetUpOption
            this.sourceType = x.sourceType
            this.troubleshootingText = x.troubleshootingText
        }

        override fun build(): CreateControlMappingSource = CreateControlMappingSource(this)
        override fun sourceDescription(sourceDescription: String): FluentBuilder = apply { this.sourceDescription = sourceDescription }
        override fun sourceFrequency(sourceFrequency: SourceFrequency): FluentBuilder = apply { this.sourceFrequency = sourceFrequency }
        override fun sourceKeyword(sourceKeyword: SourceKeyword): FluentBuilder = apply { this.sourceKeyword = sourceKeyword }
        override fun sourceName(sourceName: String): FluentBuilder = apply { this.sourceName = sourceName }
        override fun sourceSetUpOption(sourceSetUpOption: SourceSetUpOption): FluentBuilder = apply { this.sourceSetUpOption = sourceSetUpOption }
        override fun sourceType(sourceType: SourceType): FluentBuilder = apply { this.sourceType = sourceType }
        override fun troubleshootingText(troubleshootingText: String): FluentBuilder = apply { this.troubleshootingText = troubleshootingText }
    }
}
