// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The metadata associated with the specified standard or custom control.
 */
class ControlMetadata private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the specified control.
     */
    val arn: String? = builder.arn
    /**
     * The data source that determines from where Audit Manager collects evidence for the control.
     */
    val controlSources: String? = builder.controlSources
    /**
     * Specifies when the control was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The unique identifier for the specified control.
     */
    val id: String? = builder.id
    /**
     * Specifies when the control was most recently updated.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The name of the specified control.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ControlMetadata = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ControlMetadata(")
        append("arn=$arn,")
        append("controlSources=$controlSources,")
        append("createdAt=$createdAt,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (controlSources?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ControlMetadata

        if (arn != other.arn) return false
        if (controlSources != other.controlSources) return false
        if (createdAt != other.createdAt) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ControlMetadata = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ControlMetadata
        /**
         * The Amazon Resource Name (ARN) of the specified control.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The data source that determines from where Audit Manager collects evidence for the control.
         */
        fun controlSources(controlSources: String): FluentBuilder
        /**
         * Specifies when the control was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The unique identifier for the specified control.
         */
        fun id(id: String): FluentBuilder
        /**
         * Specifies when the control was most recently updated.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The name of the specified control.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the specified control.
         */
        var arn: String?
        /**
         * The data source that determines from where Audit Manager collects evidence for the control.
         */
        var controlSources: String?
        /**
         * Specifies when the control was created.
         */
        var createdAt: Instant?
        /**
         * The unique identifier for the specified control.
         */
        var id: String?
        /**
         * Specifies when the control was most recently updated.
         */
        var lastUpdatedAt: Instant?
        /**
         * The name of the specified control.
         */
        var name: String?

        fun build(): ControlMetadata
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var controlSources: String? = null
        override var createdAt: Instant? = null
        override var id: String? = null
        override var lastUpdatedAt: Instant? = null
        override var name: String? = null

        constructor(x: ControlMetadata) : this() {
            this.arn = x.arn
            this.controlSources = x.controlSources
            this.createdAt = x.createdAt
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.name = x.name
        }

        override fun build(): ControlMetadata = ControlMetadata(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun controlSources(controlSources: String): FluentBuilder = apply { this.controlSources = controlSources }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
