// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A control in Audit Manager.
 */
class Control private constructor(builder: BuilderImpl) {
    /**
     * The recommended actions to carry out if the control is not fulfilled.
     */
    val actionPlanInstructions: String? = builder.actionPlanInstructions
    /**
     * The title of the action plan for remediating the control.
     */
    val actionPlanTitle: String? = builder.actionPlanTitle
    /**
     * The Amazon Resource Name (ARN) of the specified control.
     */
    val arn: String? = builder.arn
    /**
     * The data mapping sources for the specified control.
     */
    val controlMappingSources: List<ControlMappingSource>? = builder.controlMappingSources
    /**
     * The data source that determines from where Audit Manager collects evidence for the control.
     */
    val controlSources: String? = builder.controlSources
    /**
     * Specifies when the control was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The IAM user or role that created the control.
     */
    val createdBy: String? = builder.createdBy
    /**
     * The description of the specified control.
     */
    val description: String? = builder.description
    /**
     * The unique identifier for the control.
     */
    val id: String? = builder.id
    /**
     * Specifies when the control was most recently updated.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The IAM user or role that most recently updated the control.
     */
    val lastUpdatedBy: String? = builder.lastUpdatedBy
    /**
     * The name of the specified control.
     */
    val name: String? = builder.name
    /**
     * The tags associated with the control.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The steps to follow to determine if the control has been satisfied.
     */
    val testingInformation: String? = builder.testingInformation
    /**
     * The type of control, such as custom or standard.
     */
    val type: ControlType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Control = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Control(")
        append("actionPlanInstructions=$actionPlanInstructions,")
        append("actionPlanTitle=$actionPlanTitle,")
        append("arn=$arn,")
        append("controlMappingSources=$controlMappingSources,")
        append("controlSources=$controlSources,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lastUpdatedBy=$lastUpdatedBy,")
        append("name=$name,")
        append("tags=$tags,")
        append("testingInformation=$testingInformation,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionPlanInstructions?.hashCode() ?: 0
        result = 31 * result + (actionPlanTitle?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (controlMappingSources?.hashCode() ?: 0)
        result = 31 * result + (controlSources?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedBy?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (testingInformation?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Control

        if (actionPlanInstructions != other.actionPlanInstructions) return false
        if (actionPlanTitle != other.actionPlanTitle) return false
        if (arn != other.arn) return false
        if (controlMappingSources != other.controlMappingSources) return false
        if (controlSources != other.controlSources) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lastUpdatedBy != other.lastUpdatedBy) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (testingInformation != other.testingInformation) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Control = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Control
        /**
         * The recommended actions to carry out if the control is not fulfilled.
         */
        fun actionPlanInstructions(actionPlanInstructions: String): FluentBuilder
        /**
         * The title of the action plan for remediating the control.
         */
        fun actionPlanTitle(actionPlanTitle: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the specified control.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The data mapping sources for the specified control.
         */
        fun controlMappingSources(controlMappingSources: List<ControlMappingSource>): FluentBuilder
        /**
         * The data source that determines from where Audit Manager collects evidence for the control.
         */
        fun controlSources(controlSources: String): FluentBuilder
        /**
         * Specifies when the control was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The IAM user or role that created the control.
         */
        fun createdBy(createdBy: String): FluentBuilder
        /**
         * The description of the specified control.
         */
        fun description(description: String): FluentBuilder
        /**
         * The unique identifier for the control.
         */
        fun id(id: String): FluentBuilder
        /**
         * Specifies when the control was most recently updated.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The IAM user or role that most recently updated the control.
         */
        fun lastUpdatedBy(lastUpdatedBy: String): FluentBuilder
        /**
         * The name of the specified control.
         */
        fun name(name: String): FluentBuilder
        /**
         * The tags associated with the control.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The steps to follow to determine if the control has been satisfied.
         */
        fun testingInformation(testingInformation: String): FluentBuilder
        /**
         * The type of control, such as custom or standard.
         */
        fun type(type: ControlType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The recommended actions to carry out if the control is not fulfilled.
         */
        var actionPlanInstructions: String?
        /**
         * The title of the action plan for remediating the control.
         */
        var actionPlanTitle: String?
        /**
         * The Amazon Resource Name (ARN) of the specified control.
         */
        var arn: String?
        /**
         * The data mapping sources for the specified control.
         */
        var controlMappingSources: List<ControlMappingSource>?
        /**
         * The data source that determines from where Audit Manager collects evidence for the control.
         */
        var controlSources: String?
        /**
         * Specifies when the control was created.
         */
        var createdAt: Instant?
        /**
         * The IAM user or role that created the control.
         */
        var createdBy: String?
        /**
         * The description of the specified control.
         */
        var description: String?
        /**
         * The unique identifier for the control.
         */
        var id: String?
        /**
         * Specifies when the control was most recently updated.
         */
        var lastUpdatedAt: Instant?
        /**
         * The IAM user or role that most recently updated the control.
         */
        var lastUpdatedBy: String?
        /**
         * The name of the specified control.
         */
        var name: String?
        /**
         * The tags associated with the control.
         */
        var tags: Map<String, String>?
        /**
         * The steps to follow to determine if the control has been satisfied.
         */
        var testingInformation: String?
        /**
         * The type of control, such as custom or standard.
         */
        var type: ControlType?

        fun build(): Control
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actionPlanInstructions: String? = null
        override var actionPlanTitle: String? = null
        override var arn: String? = null
        override var controlMappingSources: List<ControlMappingSource>? = null
        override var controlSources: String? = null
        override var createdAt: Instant? = null
        override var createdBy: String? = null
        override var description: String? = null
        override var id: String? = null
        override var lastUpdatedAt: Instant? = null
        override var lastUpdatedBy: String? = null
        override var name: String? = null
        override var tags: Map<String, String>? = null
        override var testingInformation: String? = null
        override var type: ControlType? = null

        constructor(x: Control) : this() {
            this.actionPlanInstructions = x.actionPlanInstructions
            this.actionPlanTitle = x.actionPlanTitle
            this.arn = x.arn
            this.controlMappingSources = x.controlMappingSources
            this.controlSources = x.controlSources
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lastUpdatedBy = x.lastUpdatedBy
            this.name = x.name
            this.tags = x.tags
            this.testingInformation = x.testingInformation
            this.type = x.type
        }

        override fun build(): Control = Control(this)
        override fun actionPlanInstructions(actionPlanInstructions: String): FluentBuilder = apply { this.actionPlanInstructions = actionPlanInstructions }
        override fun actionPlanTitle(actionPlanTitle: String): FluentBuilder = apply { this.actionPlanTitle = actionPlanTitle }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun controlMappingSources(controlMappingSources: List<ControlMappingSource>): FluentBuilder = apply { this.controlMappingSources = controlMappingSources }
        override fun controlSources(controlSources: String): FluentBuilder = apply { this.controlSources = controlSources }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun createdBy(createdBy: String): FluentBuilder = apply { this.createdBy = createdBy }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun lastUpdatedBy(lastUpdatedBy: String): FluentBuilder = apply { this.lastUpdatedBy = lastUpdatedBy }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun testingInformation(testingInformation: String): FluentBuilder = apply { this.testingInformation = testingInformation }
        override fun type(type: ControlType): FluentBuilder = apply { this.type = type }
    }
}
