// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The record of a change within Audit Manager, such as a modified assessment, a delegated control set, and so on.
 */
class ChangeLog private constructor(builder: BuilderImpl) {
    /**
     * The action performed.
     */
    val action: ActionEnum? = builder.action
    /**
     * The time of creation for the changelog object.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The IAM user or role that performed the action.
     */
    val createdBy: String? = builder.createdBy
    /**
     * The name of the changelog object.
     */
    val objectName: String? = builder.objectName
    /**
     * The changelog object type, such as an assessment, control, or control set.
     */
    val objectType: ObjectTypeEnum? = builder.objectType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ChangeLog = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeLog(")
        append("action=$action,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("objectName=$objectName,")
        append("objectType=$objectType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (objectName?.hashCode() ?: 0)
        result = 31 * result + (objectType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ChangeLog

        if (action != other.action) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (objectName != other.objectName) return false
        if (objectType != other.objectType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ChangeLog = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ChangeLog
        /**
         * The action performed.
         */
        fun action(action: ActionEnum): FluentBuilder
        /**
         * The time of creation for the changelog object.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The IAM user or role that performed the action.
         */
        fun createdBy(createdBy: String): FluentBuilder
        /**
         * The name of the changelog object.
         */
        fun objectName(objectName: String): FluentBuilder
        /**
         * The changelog object type, such as an assessment, control, or control set.
         */
        fun objectType(objectType: ObjectTypeEnum): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action performed.
         */
        var action: ActionEnum?
        /**
         * The time of creation for the changelog object.
         */
        var createdAt: Instant?
        /**
         * The IAM user or role that performed the action.
         */
        var createdBy: String?
        /**
         * The name of the changelog object.
         */
        var objectName: String?
        /**
         * The changelog object type, such as an assessment, control, or control set.
         */
        var objectType: ObjectTypeEnum?

        fun build(): ChangeLog
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: ActionEnum? = null
        override var createdAt: Instant? = null
        override var createdBy: String? = null
        override var objectName: String? = null
        override var objectType: ObjectTypeEnum? = null

        constructor(x: ChangeLog) : this() {
            this.action = x.action
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.objectName = x.objectName
            this.objectType = x.objectType
        }

        override fun build(): ChangeLog = ChangeLog(this)
        override fun action(action: ActionEnum): FluentBuilder = apply { this.action = action }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun createdBy(createdBy: String): FluentBuilder = apply { this.createdBy = createdBy }
        override fun objectName(objectName: String): FluentBuilder = apply { this.objectName = objectName }
        override fun objectType(objectType: ObjectTypeEnum): FluentBuilder = apply { this.objectType = objectType }
    }
}
