// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A finalized document generated from an Audit Manager assessment. These reports summarize the relevant evidence collected for your audit, and link to the relevant evidence folders which are named and organized according to the controls specified in your assessment.
 */
class AssessmentReport private constructor(builder: BuilderImpl) {
    /**
     * The identifier for the specified assessment.
     */
    val assessmentId: String? = builder.assessmentId
    /**
     * The name of the associated assessment.
     */
    val assessmentName: String? = builder.assessmentName
    /**
     * The name of the user who created the assessment report.
     */
    val author: String? = builder.author
    /**
     * The identifier for the specified account.
     */
    val awsAccountId: String? = builder.awsAccountId
    /**
     * Specifies when the assessment report was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The description of the specified assessment report.
     */
    val description: String? = builder.description
    /**
     * The unique identifier for the specified assessment report.
     */
    val id: String? = builder.id
    /**
     * The name given to the assessment report.
     */
    val name: String? = builder.name
    /**
     * The current status of the specified assessment report.
     */
    val status: AssessmentReportStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssessmentReport = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentReport(")
        append("assessmentId=$assessmentId,")
        append("assessmentName=$assessmentName,")
        append("author=$author,")
        append("awsAccountId=$awsAccountId,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentId?.hashCode() ?: 0
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (author?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssessmentReport

        if (assessmentId != other.assessmentId) return false
        if (assessmentName != other.assessmentName) return false
        if (author != other.author) return false
        if (awsAccountId != other.awsAccountId) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssessmentReport = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssessmentReport
        /**
         * The identifier for the specified assessment.
         */
        fun assessmentId(assessmentId: String): FluentBuilder
        /**
         * The name of the associated assessment.
         */
        fun assessmentName(assessmentName: String): FluentBuilder
        /**
         * The name of the user who created the assessment report.
         */
        fun author(author: String): FluentBuilder
        /**
         * The identifier for the specified account.
         */
        fun awsAccountId(awsAccountId: String): FluentBuilder
        /**
         * Specifies when the assessment report was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The description of the specified assessment report.
         */
        fun description(description: String): FluentBuilder
        /**
         * The unique identifier for the specified assessment report.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name given to the assessment report.
         */
        fun name(name: String): FluentBuilder
        /**
         * The current status of the specified assessment report.
         */
        fun status(status: AssessmentReportStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier for the specified assessment.
         */
        var assessmentId: String?
        /**
         * The name of the associated assessment.
         */
        var assessmentName: String?
        /**
         * The name of the user who created the assessment report.
         */
        var author: String?
        /**
         * The identifier for the specified account.
         */
        var awsAccountId: String?
        /**
         * Specifies when the assessment report was created.
         */
        var creationTime: Instant?
        /**
         * The description of the specified assessment report.
         */
        var description: String?
        /**
         * The unique identifier for the specified assessment report.
         */
        var id: String?
        /**
         * The name given to the assessment report.
         */
        var name: String?
        /**
         * The current status of the specified assessment report.
         */
        var status: AssessmentReportStatus?

        fun build(): AssessmentReport
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assessmentId: String? = null
        override var assessmentName: String? = null
        override var author: String? = null
        override var awsAccountId: String? = null
        override var creationTime: Instant? = null
        override var description: String? = null
        override var id: String? = null
        override var name: String? = null
        override var status: AssessmentReportStatus? = null

        constructor(x: AssessmentReport) : this() {
            this.assessmentId = x.assessmentId
            this.assessmentName = x.assessmentName
            this.author = x.author
            this.awsAccountId = x.awsAccountId
            this.creationTime = x.creationTime
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.status = x.status
        }

        override fun build(): AssessmentReport = AssessmentReport(this)
        override fun assessmentId(assessmentId: String): FluentBuilder = apply { this.assessmentId = assessmentId }
        override fun assessmentName(assessmentName: String): FluentBuilder = apply { this.assessmentName = assessmentName }
        override fun author(author: String): FluentBuilder = apply { this.author = author }
        override fun awsAccountId(awsAccountId: String): FluentBuilder = apply { this.awsAccountId = awsAccountId }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun status(status: AssessmentReportStatus): FluentBuilder = apply { this.status = status }
    }
}
