// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A metadata object associated with an assessment in Audit Manager.
 */
class AssessmentMetadataItem private constructor(builder: BuilderImpl) {
    /**
     * The name of the compliance standard related to the assessment, such as PCI-DSS.
     */
    val complianceType: String? = builder.complianceType
    /**
     * Specifies when the assessment was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The delegations associated with the assessment.
     */
    val delegations: List<Delegation>? = builder.delegations
    /**
     * The unique identifier for the assessment.
     */
    val id: String? = builder.id
    /**
     * The time of the most recent update.
     */
    val lastUpdated: Instant? = builder.lastUpdated
    /**
     * The name of the assessment.
     */
    val name: String? = builder.name
    /**
     * The roles associated with the assessment.
     */
    val roles: List<Role>? = builder.roles
    /**
     * The current status of the assessment.
     */
    val status: AssessmentStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssessmentMetadataItem = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentMetadataItem(")
        append("complianceType=$complianceType,")
        append("creationTime=$creationTime,")
        append("delegations=$delegations,")
        append("id=$id,")
        append("lastUpdated=$lastUpdated,")
        append("name=$name,")
        append("roles=$roles,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = complianceType?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (delegations?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roles?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssessmentMetadataItem

        if (complianceType != other.complianceType) return false
        if (creationTime != other.creationTime) return false
        if (delegations != other.delegations) return false
        if (id != other.id) return false
        if (lastUpdated != other.lastUpdated) return false
        if (name != other.name) return false
        if (roles != other.roles) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssessmentMetadataItem = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssessmentMetadataItem
        /**
         * The name of the compliance standard related to the assessment, such as PCI-DSS.
         */
        fun complianceType(complianceType: String): FluentBuilder
        /**
         * Specifies when the assessment was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The delegations associated with the assessment.
         */
        fun delegations(delegations: List<Delegation>): FluentBuilder
        /**
         * The unique identifier for the assessment.
         */
        fun id(id: String): FluentBuilder
        /**
         * The time of the most recent update.
         */
        fun lastUpdated(lastUpdated: Instant): FluentBuilder
        /**
         * The name of the assessment.
         */
        fun name(name: String): FluentBuilder
        /**
         * The roles associated with the assessment.
         */
        fun roles(roles: List<Role>): FluentBuilder
        /**
         * The current status of the assessment.
         */
        fun status(status: AssessmentStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the compliance standard related to the assessment, such as PCI-DSS.
         */
        var complianceType: String?
        /**
         * Specifies when the assessment was created.
         */
        var creationTime: Instant?
        /**
         * The delegations associated with the assessment.
         */
        var delegations: List<Delegation>?
        /**
         * The unique identifier for the assessment.
         */
        var id: String?
        /**
         * The time of the most recent update.
         */
        var lastUpdated: Instant?
        /**
         * The name of the assessment.
         */
        var name: String?
        /**
         * The roles associated with the assessment.
         */
        var roles: List<Role>?
        /**
         * The current status of the assessment.
         */
        var status: AssessmentStatus?

        fun build(): AssessmentMetadataItem
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var complianceType: String? = null
        override var creationTime: Instant? = null
        override var delegations: List<Delegation>? = null
        override var id: String? = null
        override var lastUpdated: Instant? = null
        override var name: String? = null
        override var roles: List<Role>? = null
        override var status: AssessmentStatus? = null

        constructor(x: AssessmentMetadataItem) : this() {
            this.complianceType = x.complianceType
            this.creationTime = x.creationTime
            this.delegations = x.delegations
            this.id = x.id
            this.lastUpdated = x.lastUpdated
            this.name = x.name
            this.roles = x.roles
            this.status = x.status
        }

        override fun build(): AssessmentMetadataItem = AssessmentMetadataItem(this)
        override fun complianceType(complianceType: String): FluentBuilder = apply { this.complianceType = complianceType }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun delegations(delegations: List<Delegation>): FluentBuilder = apply { this.delegations = delegations }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdated(lastUpdated: Instant): FluentBuilder = apply { this.lastUpdated = lastUpdated }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun roles(roles: List<Role>): FluentBuilder = apply { this.roles = roles }
        override fun status(status: AssessmentStatus): FluentBuilder = apply { this.status = status }
    }
}
