// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The metadata associated with the specified assessment.
 */
class AssessmentMetadata private constructor(builder: BuilderImpl) {
    /**
     * The destination in which evidence reports are stored for the specified assessment.
     */
    val assessmentReportsDestination: AssessmentReportsDestination? = builder.assessmentReportsDestination
    /**
     * The name of a compliance standard related to the assessment, such as PCI-DSS.
     */
    val complianceType: String? = builder.complianceType
    /**
     * Specifies when the assessment was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The delegations associated with the assessment.
     */
    val delegations: List<Delegation>? = builder.delegations
    /**
     * The description of the assessment.
     */
    val description: String? = builder.description
    /**
     * The unique identifier for the assessment.
     */
    val id: String? = builder.id
    /**
     * The time of the most recent update.
     */
    val lastUpdated: Instant? = builder.lastUpdated
    /**
     * The name of the assessment.
     */
    val name: String? = builder.name
    /**
     * The roles associated with the assessment.
     */
    val roles: List<Role>? = builder.roles
    /**
     * The wrapper of accounts and services in scope for the assessment.
     */
    val scope: Scope? = builder.scope
    /**
     * The overall status of the assessment.
     */
    val status: AssessmentStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssessmentMetadata = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentMetadata(")
        append("assessmentReportsDestination=$assessmentReportsDestination,")
        append("complianceType=$complianceType,")
        append("creationTime=$creationTime,")
        append("delegations=$delegations,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdated=$lastUpdated,")
        append("name=$name,")
        append("roles=$roles,")
        append("scope=$scope,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentReportsDestination?.hashCode() ?: 0
        result = 31 * result + (complianceType?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (delegations?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roles?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssessmentMetadata

        if (assessmentReportsDestination != other.assessmentReportsDestination) return false
        if (complianceType != other.complianceType) return false
        if (creationTime != other.creationTime) return false
        if (delegations != other.delegations) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdated != other.lastUpdated) return false
        if (name != other.name) return false
        if (roles != other.roles) return false
        if (scope != other.scope) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssessmentMetadata = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssessmentMetadata
        /**
         * The destination in which evidence reports are stored for the specified assessment.
         */
        fun assessmentReportsDestination(assessmentReportsDestination: AssessmentReportsDestination): FluentBuilder
        /**
         * The name of a compliance standard related to the assessment, such as PCI-DSS.
         */
        fun complianceType(complianceType: String): FluentBuilder
        /**
         * Specifies when the assessment was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The delegations associated with the assessment.
         */
        fun delegations(delegations: List<Delegation>): FluentBuilder
        /**
         * The description of the assessment.
         */
        fun description(description: String): FluentBuilder
        /**
         * The unique identifier for the assessment.
         */
        fun id(id: String): FluentBuilder
        /**
         * The time of the most recent update.
         */
        fun lastUpdated(lastUpdated: Instant): FluentBuilder
        /**
         * The name of the assessment.
         */
        fun name(name: String): FluentBuilder
        /**
         * The roles associated with the assessment.
         */
        fun roles(roles: List<Role>): FluentBuilder
        /**
         * The wrapper of accounts and services in scope for the assessment.
         */
        fun scope(scope: Scope): FluentBuilder
        /**
         * The overall status of the assessment.
         */
        fun status(status: AssessmentStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The destination in which evidence reports are stored for the specified assessment.
         */
        var assessmentReportsDestination: AssessmentReportsDestination?
        /**
         * The name of a compliance standard related to the assessment, such as PCI-DSS.
         */
        var complianceType: String?
        /**
         * Specifies when the assessment was created.
         */
        var creationTime: Instant?
        /**
         * The delegations associated with the assessment.
         */
        var delegations: List<Delegation>?
        /**
         * The description of the assessment.
         */
        var description: String?
        /**
         * The unique identifier for the assessment.
         */
        var id: String?
        /**
         * The time of the most recent update.
         */
        var lastUpdated: Instant?
        /**
         * The name of the assessment.
         */
        var name: String?
        /**
         * The roles associated with the assessment.
         */
        var roles: List<Role>?
        /**
         * The wrapper of accounts and services in scope for the assessment.
         */
        var scope: Scope?
        /**
         * The overall status of the assessment.
         */
        var status: AssessmentStatus?

        fun build(): AssessmentMetadata
        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.AssessmentReportsDestination] inside the given [block]
         */
        fun assessmentReportsDestination(block: AssessmentReportsDestination.DslBuilder.() -> kotlin.Unit) {
            this.assessmentReportsDestination = AssessmentReportsDestination.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.Scope] inside the given [block]
         */
        fun scope(block: Scope.DslBuilder.() -> kotlin.Unit) {
            this.scope = Scope.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assessmentReportsDestination: AssessmentReportsDestination? = null
        override var complianceType: String? = null
        override var creationTime: Instant? = null
        override var delegations: List<Delegation>? = null
        override var description: String? = null
        override var id: String? = null
        override var lastUpdated: Instant? = null
        override var name: String? = null
        override var roles: List<Role>? = null
        override var scope: Scope? = null
        override var status: AssessmentStatus? = null

        constructor(x: AssessmentMetadata) : this() {
            this.assessmentReportsDestination = x.assessmentReportsDestination
            this.complianceType = x.complianceType
            this.creationTime = x.creationTime
            this.delegations = x.delegations
            this.description = x.description
            this.id = x.id
            this.lastUpdated = x.lastUpdated
            this.name = x.name
            this.roles = x.roles
            this.scope = x.scope
            this.status = x.status
        }

        override fun build(): AssessmentMetadata = AssessmentMetadata(this)
        override fun assessmentReportsDestination(assessmentReportsDestination: AssessmentReportsDestination): FluentBuilder = apply { this.assessmentReportsDestination = assessmentReportsDestination }
        override fun complianceType(complianceType: String): FluentBuilder = apply { this.complianceType = complianceType }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun delegations(delegations: List<Delegation>): FluentBuilder = apply { this.delegations = delegations }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdated(lastUpdated: Instant): FluentBuilder = apply { this.lastUpdated = lastUpdated }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun roles(roles: List<Role>): FluentBuilder = apply { this.roles = roles }
        override fun scope(scope: Scope): FluentBuilder = apply { this.scope = scope }
        override fun status(status: AssessmentStatus): FluentBuilder = apply { this.status = status }
    }
}
