// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The metadata associated with a standard or custom framework.
 */
class AssessmentFrameworkMetadata private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the framework.
     */
    val arn: String? = builder.arn
    /**
     * The compliance type that the new custom framework supports, such as CIS or HIPAA.
     */
    val complianceType: String? = builder.complianceType
    /**
     * The number of control sets associated with the specified framework.
     */
    val controlSetsCount: Int = builder.controlSetsCount
    /**
     * The number of controls associated with the specified framework.
     */
    val controlsCount: Int = builder.controlsCount
    /**
     * Specifies when the framework was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The description of the specified framework.
     */
    val description: String? = builder.description
    /**
     * The unique identified for the specified framework.
     */
    val id: String? = builder.id
    /**
     * Specifies when the framework was most recently updated.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The logo associated with the framework.
     */
    val logo: String? = builder.logo
    /**
     * The name of the specified framework.
     */
    val name: String? = builder.name
    /**
     * The framework type, such as standard or custom.
     */
    val type: FrameworkType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssessmentFrameworkMetadata = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentFrameworkMetadata(")
        append("arn=$arn,")
        append("complianceType=$complianceType,")
        append("controlSetsCount=$controlSetsCount,")
        append("controlsCount=$controlsCount,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("logo=$logo,")
        append("name=$name,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (complianceType?.hashCode() ?: 0)
        result = 31 * result + (controlSetsCount)
        result = 31 * result + (controlsCount)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (logo?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssessmentFrameworkMetadata

        if (arn != other.arn) return false
        if (complianceType != other.complianceType) return false
        if (controlSetsCount != other.controlSetsCount) return false
        if (controlsCount != other.controlsCount) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (logo != other.logo) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssessmentFrameworkMetadata = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssessmentFrameworkMetadata
        /**
         * The Amazon Resource Name (ARN) of the framework.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The compliance type that the new custom framework supports, such as CIS or HIPAA.
         */
        fun complianceType(complianceType: String): FluentBuilder
        /**
         * The number of control sets associated with the specified framework.
         */
        fun controlSetsCount(controlSetsCount: Int): FluentBuilder
        /**
         * The number of controls associated with the specified framework.
         */
        fun controlsCount(controlsCount: Int): FluentBuilder
        /**
         * Specifies when the framework was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The description of the specified framework.
         */
        fun description(description: String): FluentBuilder
        /**
         * The unique identified for the specified framework.
         */
        fun id(id: String): FluentBuilder
        /**
         * Specifies when the framework was most recently updated.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The logo associated with the framework.
         */
        fun logo(logo: String): FluentBuilder
        /**
         * The name of the specified framework.
         */
        fun name(name: String): FluentBuilder
        /**
         * The framework type, such as standard or custom.
         */
        fun type(type: FrameworkType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the framework.
         */
        var arn: String?
        /**
         * The compliance type that the new custom framework supports, such as CIS or HIPAA.
         */
        var complianceType: String?
        /**
         * The number of control sets associated with the specified framework.
         */
        var controlSetsCount: Int
        /**
         * The number of controls associated with the specified framework.
         */
        var controlsCount: Int
        /**
         * Specifies when the framework was created.
         */
        var createdAt: Instant?
        /**
         * The description of the specified framework.
         */
        var description: String?
        /**
         * The unique identified for the specified framework.
         */
        var id: String?
        /**
         * Specifies when the framework was most recently updated.
         */
        var lastUpdatedAt: Instant?
        /**
         * The logo associated with the framework.
         */
        var logo: String?
        /**
         * The name of the specified framework.
         */
        var name: String?
        /**
         * The framework type, such as standard or custom.
         */
        var type: FrameworkType?

        fun build(): AssessmentFrameworkMetadata
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var complianceType: String? = null
        override var controlSetsCount: Int = 0
        override var controlsCount: Int = 0
        override var createdAt: Instant? = null
        override var description: String? = null
        override var id: String? = null
        override var lastUpdatedAt: Instant? = null
        override var logo: String? = null
        override var name: String? = null
        override var type: FrameworkType? = null

        constructor(x: AssessmentFrameworkMetadata) : this() {
            this.arn = x.arn
            this.complianceType = x.complianceType
            this.controlSetsCount = x.controlSetsCount
            this.controlsCount = x.controlsCount
            this.createdAt = x.createdAt
            this.description = x.description
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.logo = x.logo
            this.name = x.name
            this.type = x.type
        }

        override fun build(): AssessmentFrameworkMetadata = AssessmentFrameworkMetadata(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun complianceType(complianceType: String): FluentBuilder = apply { this.complianceType = complianceType }
        override fun controlSetsCount(controlSetsCount: Int): FluentBuilder = apply { this.controlSetsCount = controlSetsCount }
        override fun controlsCount(controlsCount: Int): FluentBuilder = apply { this.controlsCount = controlsCount }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun logo(logo: String): FluentBuilder = apply { this.logo = logo }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun type(type: FrameworkType): FluentBuilder = apply { this.type = type }
    }
}
