// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * The file used to structure and automate Audit Manager assessments for a given compliance standard.
 */
class AssessmentFramework private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the specified framework.
     */
    val arn: String? = builder.arn
    /**
     * The control sets associated with the framework.
     */
    val controlSets: List<AssessmentControlSet>? = builder.controlSets
    /**
     * The unique identifier for the framework.
     */
    val id: String? = builder.id
    /**
     * The metadata of a framework, such as the name, ID, description, and so on.
     */
    val metadata: FrameworkMetadata? = builder.metadata

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssessmentFramework = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentFramework(")
        append("arn=$arn,")
        append("controlSets=$controlSets,")
        append("id=$id,")
        append("metadata=$metadata)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (controlSets?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssessmentFramework

        if (arn != other.arn) return false
        if (controlSets != other.controlSets) return false
        if (id != other.id) return false
        if (metadata != other.metadata) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssessmentFramework = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssessmentFramework
        /**
         * The Amazon Resource Name (ARN) of the specified framework.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The control sets associated with the framework.
         */
        fun controlSets(controlSets: List<AssessmentControlSet>): FluentBuilder
        /**
         * The unique identifier for the framework.
         */
        fun id(id: String): FluentBuilder
        /**
         * The metadata of a framework, such as the name, ID, description, and so on.
         */
        fun metadata(metadata: FrameworkMetadata): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the specified framework.
         */
        var arn: String?
        /**
         * The control sets associated with the framework.
         */
        var controlSets: List<AssessmentControlSet>?
        /**
         * The unique identifier for the framework.
         */
        var id: String?
        /**
         * The metadata of a framework, such as the name, ID, description, and so on.
         */
        var metadata: FrameworkMetadata?

        fun build(): AssessmentFramework
        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.FrameworkMetadata] inside the given [block]
         */
        fun metadata(block: FrameworkMetadata.DslBuilder.() -> kotlin.Unit) {
            this.metadata = FrameworkMetadata.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var controlSets: List<AssessmentControlSet>? = null
        override var id: String? = null
        override var metadata: FrameworkMetadata? = null

        constructor(x: AssessmentFramework) : this() {
            this.arn = x.arn
            this.controlSets = x.controlSets
            this.id = x.id
            this.metadata = x.metadata
        }

        override fun build(): AssessmentFramework = AssessmentFramework(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun controlSets(controlSets: List<AssessmentControlSet>): FluentBuilder = apply { this.controlSets = controlSets }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun metadata(metadata: FrameworkMetadata): FluentBuilder = apply { this.metadata = metadata }
    }
}
