// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The folder in which Audit Manager stores evidence for an assessment.
 */
class AssessmentEvidenceFolder private constructor(builder: BuilderImpl) {
    /**
     * The identifier for the specified assessment.
     */
    val assessmentId: String? = builder.assessmentId
    /**
     * The total count of evidence included in the assessment report.
     */
    val assessmentReportSelectionCount: Int = builder.assessmentReportSelectionCount
    /**
     * The name of the user who created the evidence folder.
     */
    val author: String? = builder.author
    /**
     * The unique identifier for the specified control.
     */
    val controlId: String? = builder.controlId
    /**
     * The name of the control.
     */
    val controlName: String? = builder.controlName
    /**
     * The identifier for the control set.
     */
    val controlSetId: String? = builder.controlSetId
    /**
     * The Amazon Web Service from which the evidence was collected.
     */
    val dataSource: String? = builder.dataSource
    /**
     * The date when the first evidence was added to the evidence folder.
     */
    val date: Instant? = builder.date
    /**
     * The total number of Amazon Web Services resources assessed to generate the evidence.
     */
    val evidenceAwsServiceSourceCount: Int = builder.evidenceAwsServiceSourceCount
    /**
     * The number of evidence that falls under the compliance check category. This evidence is collected from Config or Security Hub.
     */
    val evidenceByTypeComplianceCheckCount: Int = builder.evidenceByTypeComplianceCheckCount
    /**
     * The total number of issues that were reported directly from Security Hub, Config, or both.
     */
    val evidenceByTypeComplianceCheckIssuesCount: Int = builder.evidenceByTypeComplianceCheckIssuesCount
    /**
     * The number of evidence that falls under the configuration data category. This evidence is collected from configuration snapshots of other Amazon Web Services services such as Amazon EC2, Amazon S3, or IAM.
     */
    val evidenceByTypeConfigurationDataCount: Int = builder.evidenceByTypeConfigurationDataCount
    /**
     * The number of evidence that falls under the manual category. This evidence is imported manually.
     */
    val evidenceByTypeManualCount: Int = builder.evidenceByTypeManualCount
    /**
     * The number of evidence that falls under the user activity category. This evidence is collected from CloudTrail logs.
     */
    val evidenceByTypeUserActivityCount: Int = builder.evidenceByTypeUserActivityCount
    /**
     * The amount of evidence included in the evidence folder.
     */
    val evidenceResourcesIncludedCount: Int = builder.evidenceResourcesIncludedCount
    /**
     * The identifier for the folder in which evidence is stored.
     */
    val id: String? = builder.id
    /**
     * The name of the specified evidence folder.
     */
    val name: String? = builder.name
    /**
     * The total amount of evidence in the evidence folder.
     */
    val totalEvidence: Int = builder.totalEvidence

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssessmentEvidenceFolder = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentEvidenceFolder(")
        append("assessmentId=$assessmentId,")
        append("assessmentReportSelectionCount=$assessmentReportSelectionCount,")
        append("author=$author,")
        append("controlId=$controlId,")
        append("controlName=$controlName,")
        append("controlSetId=$controlSetId,")
        append("dataSource=$dataSource,")
        append("date=$date,")
        append("evidenceAwsServiceSourceCount=$evidenceAwsServiceSourceCount,")
        append("evidenceByTypeComplianceCheckCount=$evidenceByTypeComplianceCheckCount,")
        append("evidenceByTypeComplianceCheckIssuesCount=$evidenceByTypeComplianceCheckIssuesCount,")
        append("evidenceByTypeConfigurationDataCount=$evidenceByTypeConfigurationDataCount,")
        append("evidenceByTypeManualCount=$evidenceByTypeManualCount,")
        append("evidenceByTypeUserActivityCount=$evidenceByTypeUserActivityCount,")
        append("evidenceResourcesIncludedCount=$evidenceResourcesIncludedCount,")
        append("id=$id,")
        append("name=$name,")
        append("totalEvidence=$totalEvidence)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentId?.hashCode() ?: 0
        result = 31 * result + (assessmentReportSelectionCount)
        result = 31 * result + (author?.hashCode() ?: 0)
        result = 31 * result + (controlId?.hashCode() ?: 0)
        result = 31 * result + (controlName?.hashCode() ?: 0)
        result = 31 * result + (controlSetId?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (date?.hashCode() ?: 0)
        result = 31 * result + (evidenceAwsServiceSourceCount)
        result = 31 * result + (evidenceByTypeComplianceCheckCount)
        result = 31 * result + (evidenceByTypeComplianceCheckIssuesCount)
        result = 31 * result + (evidenceByTypeConfigurationDataCount)
        result = 31 * result + (evidenceByTypeManualCount)
        result = 31 * result + (evidenceByTypeUserActivityCount)
        result = 31 * result + (evidenceResourcesIncludedCount)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (totalEvidence)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssessmentEvidenceFolder

        if (assessmentId != other.assessmentId) return false
        if (assessmentReportSelectionCount != other.assessmentReportSelectionCount) return false
        if (author != other.author) return false
        if (controlId != other.controlId) return false
        if (controlName != other.controlName) return false
        if (controlSetId != other.controlSetId) return false
        if (dataSource != other.dataSource) return false
        if (date != other.date) return false
        if (evidenceAwsServiceSourceCount != other.evidenceAwsServiceSourceCount) return false
        if (evidenceByTypeComplianceCheckCount != other.evidenceByTypeComplianceCheckCount) return false
        if (evidenceByTypeComplianceCheckIssuesCount != other.evidenceByTypeComplianceCheckIssuesCount) return false
        if (evidenceByTypeConfigurationDataCount != other.evidenceByTypeConfigurationDataCount) return false
        if (evidenceByTypeManualCount != other.evidenceByTypeManualCount) return false
        if (evidenceByTypeUserActivityCount != other.evidenceByTypeUserActivityCount) return false
        if (evidenceResourcesIncludedCount != other.evidenceResourcesIncludedCount) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (totalEvidence != other.totalEvidence) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssessmentEvidenceFolder = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssessmentEvidenceFolder
        /**
         * The identifier for the specified assessment.
         */
        fun assessmentId(assessmentId: String): FluentBuilder
        /**
         * The total count of evidence included in the assessment report.
         */
        fun assessmentReportSelectionCount(assessmentReportSelectionCount: Int): FluentBuilder
        /**
         * The name of the user who created the evidence folder.
         */
        fun author(author: String): FluentBuilder
        /**
         * The unique identifier for the specified control.
         */
        fun controlId(controlId: String): FluentBuilder
        /**
         * The name of the control.
         */
        fun controlName(controlName: String): FluentBuilder
        /**
         * The identifier for the control set.
         */
        fun controlSetId(controlSetId: String): FluentBuilder
        /**
         * The Amazon Web Service from which the evidence was collected.
         */
        fun dataSource(dataSource: String): FluentBuilder
        /**
         * The date when the first evidence was added to the evidence folder.
         */
        fun date(date: Instant): FluentBuilder
        /**
         * The total number of Amazon Web Services resources assessed to generate the evidence.
         */
        fun evidenceAwsServiceSourceCount(evidenceAwsServiceSourceCount: Int): FluentBuilder
        /**
         * The number of evidence that falls under the compliance check category. This evidence is collected from Config or Security Hub.
         */
        fun evidenceByTypeComplianceCheckCount(evidenceByTypeComplianceCheckCount: Int): FluentBuilder
        /**
         * The total number of issues that were reported directly from Security Hub, Config, or both.
         */
        fun evidenceByTypeComplianceCheckIssuesCount(evidenceByTypeComplianceCheckIssuesCount: Int): FluentBuilder
        /**
         * The number of evidence that falls under the configuration data category. This evidence is collected from configuration snapshots of other Amazon Web Services services such as Amazon EC2, Amazon S3, or IAM.
         */
        fun evidenceByTypeConfigurationDataCount(evidenceByTypeConfigurationDataCount: Int): FluentBuilder
        /**
         * The number of evidence that falls under the manual category. This evidence is imported manually.
         */
        fun evidenceByTypeManualCount(evidenceByTypeManualCount: Int): FluentBuilder
        /**
         * The number of evidence that falls under the user activity category. This evidence is collected from CloudTrail logs.
         */
        fun evidenceByTypeUserActivityCount(evidenceByTypeUserActivityCount: Int): FluentBuilder
        /**
         * The amount of evidence included in the evidence folder.
         */
        fun evidenceResourcesIncludedCount(evidenceResourcesIncludedCount: Int): FluentBuilder
        /**
         * The identifier for the folder in which evidence is stored.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of the specified evidence folder.
         */
        fun name(name: String): FluentBuilder
        /**
         * The total amount of evidence in the evidence folder.
         */
        fun totalEvidence(totalEvidence: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier for the specified assessment.
         */
        var assessmentId: String?
        /**
         * The total count of evidence included in the assessment report.
         */
        var assessmentReportSelectionCount: Int
        /**
         * The name of the user who created the evidence folder.
         */
        var author: String?
        /**
         * The unique identifier for the specified control.
         */
        var controlId: String?
        /**
         * The name of the control.
         */
        var controlName: String?
        /**
         * The identifier for the control set.
         */
        var controlSetId: String?
        /**
         * The Amazon Web Service from which the evidence was collected.
         */
        var dataSource: String?
        /**
         * The date when the first evidence was added to the evidence folder.
         */
        var date: Instant?
        /**
         * The total number of Amazon Web Services resources assessed to generate the evidence.
         */
        var evidenceAwsServiceSourceCount: Int
        /**
         * The number of evidence that falls under the compliance check category. This evidence is collected from Config or Security Hub.
         */
        var evidenceByTypeComplianceCheckCount: Int
        /**
         * The total number of issues that were reported directly from Security Hub, Config, or both.
         */
        var evidenceByTypeComplianceCheckIssuesCount: Int
        /**
         * The number of evidence that falls under the configuration data category. This evidence is collected from configuration snapshots of other Amazon Web Services services such as Amazon EC2, Amazon S3, or IAM.
         */
        var evidenceByTypeConfigurationDataCount: Int
        /**
         * The number of evidence that falls under the manual category. This evidence is imported manually.
         */
        var evidenceByTypeManualCount: Int
        /**
         * The number of evidence that falls under the user activity category. This evidence is collected from CloudTrail logs.
         */
        var evidenceByTypeUserActivityCount: Int
        /**
         * The amount of evidence included in the evidence folder.
         */
        var evidenceResourcesIncludedCount: Int
        /**
         * The identifier for the folder in which evidence is stored.
         */
        var id: String?
        /**
         * The name of the specified evidence folder.
         */
        var name: String?
        /**
         * The total amount of evidence in the evidence folder.
         */
        var totalEvidence: Int

        fun build(): AssessmentEvidenceFolder
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assessmentId: String? = null
        override var assessmentReportSelectionCount: Int = 0
        override var author: String? = null
        override var controlId: String? = null
        override var controlName: String? = null
        override var controlSetId: String? = null
        override var dataSource: String? = null
        override var date: Instant? = null
        override var evidenceAwsServiceSourceCount: Int = 0
        override var evidenceByTypeComplianceCheckCount: Int = 0
        override var evidenceByTypeComplianceCheckIssuesCount: Int = 0
        override var evidenceByTypeConfigurationDataCount: Int = 0
        override var evidenceByTypeManualCount: Int = 0
        override var evidenceByTypeUserActivityCount: Int = 0
        override var evidenceResourcesIncludedCount: Int = 0
        override var id: String? = null
        override var name: String? = null
        override var totalEvidence: Int = 0

        constructor(x: AssessmentEvidenceFolder) : this() {
            this.assessmentId = x.assessmentId
            this.assessmentReportSelectionCount = x.assessmentReportSelectionCount
            this.author = x.author
            this.controlId = x.controlId
            this.controlName = x.controlName
            this.controlSetId = x.controlSetId
            this.dataSource = x.dataSource
            this.date = x.date
            this.evidenceAwsServiceSourceCount = x.evidenceAwsServiceSourceCount
            this.evidenceByTypeComplianceCheckCount = x.evidenceByTypeComplianceCheckCount
            this.evidenceByTypeComplianceCheckIssuesCount = x.evidenceByTypeComplianceCheckIssuesCount
            this.evidenceByTypeConfigurationDataCount = x.evidenceByTypeConfigurationDataCount
            this.evidenceByTypeManualCount = x.evidenceByTypeManualCount
            this.evidenceByTypeUserActivityCount = x.evidenceByTypeUserActivityCount
            this.evidenceResourcesIncludedCount = x.evidenceResourcesIncludedCount
            this.id = x.id
            this.name = x.name
            this.totalEvidence = x.totalEvidence
        }

        override fun build(): AssessmentEvidenceFolder = AssessmentEvidenceFolder(this)
        override fun assessmentId(assessmentId: String): FluentBuilder = apply { this.assessmentId = assessmentId }
        override fun assessmentReportSelectionCount(assessmentReportSelectionCount: Int): FluentBuilder = apply { this.assessmentReportSelectionCount = assessmentReportSelectionCount }
        override fun author(author: String): FluentBuilder = apply { this.author = author }
        override fun controlId(controlId: String): FluentBuilder = apply { this.controlId = controlId }
        override fun controlName(controlName: String): FluentBuilder = apply { this.controlName = controlName }
        override fun controlSetId(controlSetId: String): FluentBuilder = apply { this.controlSetId = controlSetId }
        override fun dataSource(dataSource: String): FluentBuilder = apply { this.dataSource = dataSource }
        override fun date(date: Instant): FluentBuilder = apply { this.date = date }
        override fun evidenceAwsServiceSourceCount(evidenceAwsServiceSourceCount: Int): FluentBuilder = apply { this.evidenceAwsServiceSourceCount = evidenceAwsServiceSourceCount }
        override fun evidenceByTypeComplianceCheckCount(evidenceByTypeComplianceCheckCount: Int): FluentBuilder = apply { this.evidenceByTypeComplianceCheckCount = evidenceByTypeComplianceCheckCount }
        override fun evidenceByTypeComplianceCheckIssuesCount(evidenceByTypeComplianceCheckIssuesCount: Int): FluentBuilder = apply { this.evidenceByTypeComplianceCheckIssuesCount = evidenceByTypeComplianceCheckIssuesCount }
        override fun evidenceByTypeConfigurationDataCount(evidenceByTypeConfigurationDataCount: Int): FluentBuilder = apply { this.evidenceByTypeConfigurationDataCount = evidenceByTypeConfigurationDataCount }
        override fun evidenceByTypeManualCount(evidenceByTypeManualCount: Int): FluentBuilder = apply { this.evidenceByTypeManualCount = evidenceByTypeManualCount }
        override fun evidenceByTypeUserActivityCount(evidenceByTypeUserActivityCount: Int): FluentBuilder = apply { this.evidenceByTypeUserActivityCount = evidenceByTypeUserActivityCount }
        override fun evidenceResourcesIncludedCount(evidenceResourcesIncludedCount: Int): FluentBuilder = apply { this.evidenceResourcesIncludedCount = evidenceResourcesIncludedCount }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun totalEvidence(totalEvidence: Int): FluentBuilder = apply { this.totalEvidence = totalEvidence }
    }
}
