// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * Represents a set of controls in an Audit Manager assessment.
 */
class AssessmentControlSet private constructor(builder: BuilderImpl) {
    /**
     * The list of controls contained with the control set.
     */
    val controls: List<AssessmentControl>? = builder.controls
    /**
     * The delegations associated with the control set.
     */
    val delegations: List<Delegation>? = builder.delegations
    /**
     * The description for the control set.
     */
    val description: String? = builder.description
    /**
     * The identifier of the control set in the assessment. This is the control set name in a plain string format.
     */
    val id: String? = builder.id
    /**
     * The total number of evidence objects uploaded manually to the control set.
     */
    val manualEvidenceCount: Int = builder.manualEvidenceCount
    /**
     * The roles associated with the control set.
     */
    val roles: List<Role>? = builder.roles
    /**
     * Specifies the current status of the control set.
     */
    val status: ControlSetStatus? = builder.status
    /**
     * The total number of evidence objects retrieved automatically for the control set.
     */
    val systemEvidenceCount: Int = builder.systemEvidenceCount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssessmentControlSet = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentControlSet(")
        append("controls=$controls,")
        append("delegations=$delegations,")
        append("description=$description,")
        append("id=$id,")
        append("manualEvidenceCount=$manualEvidenceCount,")
        append("roles=$roles,")
        append("status=$status,")
        append("systemEvidenceCount=$systemEvidenceCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = controls?.hashCode() ?: 0
        result = 31 * result + (delegations?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (manualEvidenceCount)
        result = 31 * result + (roles?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (systemEvidenceCount)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssessmentControlSet

        if (controls != other.controls) return false
        if (delegations != other.delegations) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (manualEvidenceCount != other.manualEvidenceCount) return false
        if (roles != other.roles) return false
        if (status != other.status) return false
        if (systemEvidenceCount != other.systemEvidenceCount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssessmentControlSet = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssessmentControlSet
        /**
         * The list of controls contained with the control set.
         */
        fun controls(controls: List<AssessmentControl>): FluentBuilder
        /**
         * The delegations associated with the control set.
         */
        fun delegations(delegations: List<Delegation>): FluentBuilder
        /**
         * The description for the control set.
         */
        fun description(description: String): FluentBuilder
        /**
         * The identifier of the control set in the assessment. This is the control set name in a plain string format.
         */
        fun id(id: String): FluentBuilder
        /**
         * The total number of evidence objects uploaded manually to the control set.
         */
        fun manualEvidenceCount(manualEvidenceCount: Int): FluentBuilder
        /**
         * The roles associated with the control set.
         */
        fun roles(roles: List<Role>): FluentBuilder
        /**
         * Specifies the current status of the control set.
         */
        fun status(status: ControlSetStatus): FluentBuilder
        /**
         * The total number of evidence objects retrieved automatically for the control set.
         */
        fun systemEvidenceCount(systemEvidenceCount: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The list of controls contained with the control set.
         */
        var controls: List<AssessmentControl>?
        /**
         * The delegations associated with the control set.
         */
        var delegations: List<Delegation>?
        /**
         * The description for the control set.
         */
        var description: String?
        /**
         * The identifier of the control set in the assessment. This is the control set name in a plain string format.
         */
        var id: String?
        /**
         * The total number of evidence objects uploaded manually to the control set.
         */
        var manualEvidenceCount: Int
        /**
         * The roles associated with the control set.
         */
        var roles: List<Role>?
        /**
         * Specifies the current status of the control set.
         */
        var status: ControlSetStatus?
        /**
         * The total number of evidence objects retrieved automatically for the control set.
         */
        var systemEvidenceCount: Int

        fun build(): AssessmentControlSet
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var controls: List<AssessmentControl>? = null
        override var delegations: List<Delegation>? = null
        override var description: String? = null
        override var id: String? = null
        override var manualEvidenceCount: Int = 0
        override var roles: List<Role>? = null
        override var status: ControlSetStatus? = null
        override var systemEvidenceCount: Int = 0

        constructor(x: AssessmentControlSet) : this() {
            this.controls = x.controls
            this.delegations = x.delegations
            this.description = x.description
            this.id = x.id
            this.manualEvidenceCount = x.manualEvidenceCount
            this.roles = x.roles
            this.status = x.status
            this.systemEvidenceCount = x.systemEvidenceCount
        }

        override fun build(): AssessmentControlSet = AssessmentControlSet(this)
        override fun controls(controls: List<AssessmentControl>): FluentBuilder = apply { this.controls = controls }
        override fun delegations(delegations: List<Delegation>): FluentBuilder = apply { this.delegations = delegations }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun manualEvidenceCount(manualEvidenceCount: Int): FluentBuilder = apply { this.manualEvidenceCount = manualEvidenceCount }
        override fun roles(roles: List<Role>): FluentBuilder = apply { this.roles = roles }
        override fun status(status: ControlSetStatus): FluentBuilder = apply { this.status = status }
        override fun systemEvidenceCount(systemEvidenceCount: Int): FluentBuilder = apply { this.systemEvidenceCount = systemEvidenceCount }
    }
}
