// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * The control entity that represents a standard or custom control used in an Audit Manager assessment.
 */
class AssessmentControl private constructor(builder: BuilderImpl) {
    /**
     * The amount of evidence in the assessment report.
     */
    val assessmentReportEvidenceCount: Int = builder.assessmentReportEvidenceCount
    /**
     * The list of comments attached to the specified control.
     */
    val comments: List<ControlComment>? = builder.comments
    /**
     * The description of the specified control.
     */
    val description: String? = builder.description
    /**
     * The amount of evidence generated for the control.
     */
    val evidenceCount: Int = builder.evidenceCount
    /**
     * The list of data sources for the specified evidence.
     */
    val evidenceSources: List<String>? = builder.evidenceSources
    /**
     * The identifier for the specified control.
     */
    val id: String? = builder.id
    /**
     * The name of the specified control.
     */
    val name: String? = builder.name
    /**
     * The response of the specified control.
     */
    val response: ControlResponse? = builder.response
    /**
     * The status of the specified control.
     */
    val status: ControlStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssessmentControl = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentControl(")
        append("assessmentReportEvidenceCount=$assessmentReportEvidenceCount,")
        append("comments=$comments,")
        append("description=$description,")
        append("evidenceCount=$evidenceCount,")
        append("evidenceSources=$evidenceSources,")
        append("id=$id,")
        append("name=$name,")
        append("response=$response,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentReportEvidenceCount
        result = 31 * result + (comments?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (evidenceCount)
        result = 31 * result + (evidenceSources?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (response?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssessmentControl

        if (assessmentReportEvidenceCount != other.assessmentReportEvidenceCount) return false
        if (comments != other.comments) return false
        if (description != other.description) return false
        if (evidenceCount != other.evidenceCount) return false
        if (evidenceSources != other.evidenceSources) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (response != other.response) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssessmentControl = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssessmentControl
        /**
         * The amount of evidence in the assessment report.
         */
        fun assessmentReportEvidenceCount(assessmentReportEvidenceCount: Int): FluentBuilder
        /**
         * The list of comments attached to the specified control.
         */
        fun comments(comments: List<ControlComment>): FluentBuilder
        /**
         * The description of the specified control.
         */
        fun description(description: String): FluentBuilder
        /**
         * The amount of evidence generated for the control.
         */
        fun evidenceCount(evidenceCount: Int): FluentBuilder
        /**
         * The list of data sources for the specified evidence.
         */
        fun evidenceSources(evidenceSources: List<String>): FluentBuilder
        /**
         * The identifier for the specified control.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of the specified control.
         */
        fun name(name: String): FluentBuilder
        /**
         * The response of the specified control.
         */
        fun response(response: ControlResponse): FluentBuilder
        /**
         * The status of the specified control.
         */
        fun status(status: ControlStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The amount of evidence in the assessment report.
         */
        var assessmentReportEvidenceCount: Int
        /**
         * The list of comments attached to the specified control.
         */
        var comments: List<ControlComment>?
        /**
         * The description of the specified control.
         */
        var description: String?
        /**
         * The amount of evidence generated for the control.
         */
        var evidenceCount: Int
        /**
         * The list of data sources for the specified evidence.
         */
        var evidenceSources: List<String>?
        /**
         * The identifier for the specified control.
         */
        var id: String?
        /**
         * The name of the specified control.
         */
        var name: String?
        /**
         * The response of the specified control.
         */
        var response: ControlResponse?
        /**
         * The status of the specified control.
         */
        var status: ControlStatus?

        fun build(): AssessmentControl
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assessmentReportEvidenceCount: Int = 0
        override var comments: List<ControlComment>? = null
        override var description: String? = null
        override var evidenceCount: Int = 0
        override var evidenceSources: List<String>? = null
        override var id: String? = null
        override var name: String? = null
        override var response: ControlResponse? = null
        override var status: ControlStatus? = null

        constructor(x: AssessmentControl) : this() {
            this.assessmentReportEvidenceCount = x.assessmentReportEvidenceCount
            this.comments = x.comments
            this.description = x.description
            this.evidenceCount = x.evidenceCount
            this.evidenceSources = x.evidenceSources
            this.id = x.id
            this.name = x.name
            this.response = x.response
            this.status = x.status
        }

        override fun build(): AssessmentControl = AssessmentControl(this)
        override fun assessmentReportEvidenceCount(assessmentReportEvidenceCount: Int): FluentBuilder = apply { this.assessmentReportEvidenceCount = assessmentReportEvidenceCount }
        override fun comments(comments: List<ControlComment>): FluentBuilder = apply { this.comments = comments }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun evidenceCount(evidenceCount: Int): FluentBuilder = apply { this.evidenceCount = evidenceCount }
        override fun evidenceSources(evidenceSources: List<String>): FluentBuilder = apply { this.evidenceSources = evidenceSources }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun response(response: ControlResponse): FluentBuilder = apply { this.response = response }
        override fun status(status: ControlStatus): FluentBuilder = apply { this.status = status }
    }
}
