// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * An entity that defines the scope of audit evidence collected by Audit Manager. An Audit Manager assessment is an implementation of an Audit Manager framework.
 */
class Assessment private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the assessment.
     */
    val arn: String? = builder.arn
    /**
     * The account associated with the assessment.
     */
    val awsAccount: AwsAccount? = builder.awsAccount
    /**
     * The framework from which the assessment was created.
     */
    val framework: AssessmentFramework? = builder.framework
    /**
     * The metadata for the specified assessment.
     */
    val metadata: AssessmentMetadata? = builder.metadata
    /**
     * The tags associated with the assessment.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Assessment = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Assessment(")
        append("arn=$arn,")
        append("awsAccount=$awsAccount,")
        append("framework=$framework,")
        append("metadata=$metadata,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (awsAccount?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Assessment

        if (arn != other.arn) return false
        if (awsAccount != other.awsAccount) return false
        if (framework != other.framework) return false
        if (metadata != other.metadata) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Assessment = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Assessment
        /**
         * The Amazon Resource Name (ARN) of the assessment.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The account associated with the assessment.
         */
        fun awsAccount(awsAccount: AwsAccount): FluentBuilder
        /**
         * The framework from which the assessment was created.
         */
        fun framework(framework: AssessmentFramework): FluentBuilder
        /**
         * The metadata for the specified assessment.
         */
        fun metadata(metadata: AssessmentMetadata): FluentBuilder
        /**
         * The tags associated with the assessment.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the assessment.
         */
        var arn: String?
        /**
         * The account associated with the assessment.
         */
        var awsAccount: AwsAccount?
        /**
         * The framework from which the assessment was created.
         */
        var framework: AssessmentFramework?
        /**
         * The metadata for the specified assessment.
         */
        var metadata: AssessmentMetadata?
        /**
         * The tags associated with the assessment.
         */
        var tags: Map<String, String>?

        fun build(): Assessment
        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.AwsAccount] inside the given [block]
         */
        fun awsAccount(block: AwsAccount.DslBuilder.() -> kotlin.Unit) {
            this.awsAccount = AwsAccount.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.AssessmentFramework] inside the given [block]
         */
        fun framework(block: AssessmentFramework.DslBuilder.() -> kotlin.Unit) {
            this.framework = AssessmentFramework.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.AssessmentMetadata] inside the given [block]
         */
        fun metadata(block: AssessmentMetadata.DslBuilder.() -> kotlin.Unit) {
            this.metadata = AssessmentMetadata.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var awsAccount: AwsAccount? = null
        override var framework: AssessmentFramework? = null
        override var metadata: AssessmentMetadata? = null
        override var tags: Map<String, String>? = null

        constructor(x: Assessment) : this() {
            this.arn = x.arn
            this.awsAccount = x.awsAccount
            this.framework = x.framework
            this.metadata = x.metadata
            this.tags = x.tags
        }

        override fun build(): Assessment = Assessment(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun awsAccount(awsAccount: AwsAccount): FluentBuilder = apply { this.awsAccount = awsAccount }
        override fun framework(framework: AssessmentFramework): FluentBuilder = apply { this.framework = framework }
        override fun metadata(metadata: AssessmentMetadata): FluentBuilder = apply { this.metadata = metadata }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
