// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.region.resolveRegionForOperation
import aws.sdk.kotlin.services.auditmanager.model.*
import aws.sdk.kotlin.services.auditmanager.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngineConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "AuditManager"
const val ServiceApiVersion: String = "2017-07-25"
const val SdkVersion: String = "0.7.0-alpha"

internal class DefaultAuditManagerClient(override val config: AuditManagerClient.Config) : AuditManagerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Associates an evidence folder to the specified assessment report in Audit Manager.
     */
    override suspend fun associateAssessmentReportEvidenceFolder(input: AssociateAssessmentReportEvidenceFolderRequest): AssociateAssessmentReportEvidenceFolderResponse {
        val op = SdkHttpOperation.build<AssociateAssessmentReportEvidenceFolderRequest, AssociateAssessmentReportEvidenceFolderResponse> {
            serializer = AssociateAssessmentReportEvidenceFolderOperationSerializer()
            deserializer = AssociateAssessmentReportEvidenceFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateAssessmentReportEvidenceFolder"
            }
        }
        registerAssociateAssessmentReportEvidenceFolderMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a list of evidence to an assessment report in an Audit Manager assessment.
     */
    override suspend fun batchAssociateAssessmentReportEvidence(input: BatchAssociateAssessmentReportEvidenceRequest): BatchAssociateAssessmentReportEvidenceResponse {
        val op = SdkHttpOperation.build<BatchAssociateAssessmentReportEvidenceRequest, BatchAssociateAssessmentReportEvidenceResponse> {
            serializer = BatchAssociateAssessmentReportEvidenceOperationSerializer()
            deserializer = BatchAssociateAssessmentReportEvidenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchAssociateAssessmentReportEvidence"
            }
        }
        registerBatchAssociateAssessmentReportEvidenceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Create a batch of delegations for a specified assessment in Audit Manager.
     */
    override suspend fun batchCreateDelegationByAssessment(input: BatchCreateDelegationByAssessmentRequest): BatchCreateDelegationByAssessmentResponse {
        val op = SdkHttpOperation.build<BatchCreateDelegationByAssessmentRequest, BatchCreateDelegationByAssessmentResponse> {
            serializer = BatchCreateDelegationByAssessmentOperationSerializer()
            deserializer = BatchCreateDelegationByAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchCreateDelegationByAssessment"
            }
        }
        registerBatchCreateDelegationByAssessmentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the delegations in the specified Audit Manager assessment.
     */
    override suspend fun batchDeleteDelegationByAssessment(input: BatchDeleteDelegationByAssessmentRequest): BatchDeleteDelegationByAssessmentResponse {
        val op = SdkHttpOperation.build<BatchDeleteDelegationByAssessmentRequest, BatchDeleteDelegationByAssessmentResponse> {
            serializer = BatchDeleteDelegationByAssessmentOperationSerializer()
            deserializer = BatchDeleteDelegationByAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeleteDelegationByAssessment"
            }
        }
        registerBatchDeleteDelegationByAssessmentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a list of evidence from the specified assessment report in Audit Manager.
     */
    override suspend fun batchDisassociateAssessmentReportEvidence(input: BatchDisassociateAssessmentReportEvidenceRequest): BatchDisassociateAssessmentReportEvidenceResponse {
        val op = SdkHttpOperation.build<BatchDisassociateAssessmentReportEvidenceRequest, BatchDisassociateAssessmentReportEvidenceResponse> {
            serializer = BatchDisassociateAssessmentReportEvidenceOperationSerializer()
            deserializer = BatchDisassociateAssessmentReportEvidenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDisassociateAssessmentReportEvidence"
            }
        }
        registerBatchDisassociateAssessmentReportEvidenceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Uploads one or more pieces of evidence to the specified control in the assessment in Audit Manager.
     */
    override suspend fun batchImportEvidenceToAssessmentControl(input: BatchImportEvidenceToAssessmentControlRequest): BatchImportEvidenceToAssessmentControlResponse {
        val op = SdkHttpOperation.build<BatchImportEvidenceToAssessmentControlRequest, BatchImportEvidenceToAssessmentControlResponse> {
            serializer = BatchImportEvidenceToAssessmentControlOperationSerializer()
            deserializer = BatchImportEvidenceToAssessmentControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchImportEvidenceToAssessmentControl"
            }
        }
        registerBatchImportEvidenceToAssessmentControlMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an assessment in Audit Manager.
     */
    override suspend fun createAssessment(input: CreateAssessmentRequest): CreateAssessmentResponse {
        val op = SdkHttpOperation.build<CreateAssessmentRequest, CreateAssessmentResponse> {
            serializer = CreateAssessmentOperationSerializer()
            deserializer = CreateAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAssessment"
            }
        }
        registerCreateAssessmentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom framework in Audit Manager.
     */
    override suspend fun createAssessmentFramework(input: CreateAssessmentFrameworkRequest): CreateAssessmentFrameworkResponse {
        val op = SdkHttpOperation.build<CreateAssessmentFrameworkRequest, CreateAssessmentFrameworkResponse> {
            serializer = CreateAssessmentFrameworkOperationSerializer()
            deserializer = CreateAssessmentFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAssessmentFramework"
            }
        }
        registerCreateAssessmentFrameworkMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an assessment report for the specified assessment.
     */
    override suspend fun createAssessmentReport(input: CreateAssessmentReportRequest): CreateAssessmentReportResponse {
        val op = SdkHttpOperation.build<CreateAssessmentReportRequest, CreateAssessmentReportResponse> {
            serializer = CreateAssessmentReportOperationSerializer()
            deserializer = CreateAssessmentReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAssessmentReport"
            }
        }
        registerCreateAssessmentReportMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom control in Audit Manager.
     */
    override suspend fun createControl(input: CreateControlRequest): CreateControlResponse {
        val op = SdkHttpOperation.build<CreateControlRequest, CreateControlResponse> {
            serializer = CreateControlOperationSerializer()
            deserializer = CreateControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateControl"
            }
        }
        registerCreateControlMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an assessment in Audit Manager.
     */
    override suspend fun deleteAssessment(input: DeleteAssessmentRequest): DeleteAssessmentResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentRequest, DeleteAssessmentResponse> {
            serializer = DeleteAssessmentOperationSerializer()
            deserializer = DeleteAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAssessment"
            }
        }
        registerDeleteAssessmentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom framework in Audit Manager.
     */
    override suspend fun deleteAssessmentFramework(input: DeleteAssessmentFrameworkRequest): DeleteAssessmentFrameworkResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentFrameworkRequest, DeleteAssessmentFrameworkResponse> {
            serializer = DeleteAssessmentFrameworkOperationSerializer()
            deserializer = DeleteAssessmentFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAssessmentFramework"
            }
        }
        registerDeleteAssessmentFrameworkMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an assessment report from an assessment in Audit Manager.
     */
    override suspend fun deleteAssessmentReport(input: DeleteAssessmentReportRequest): DeleteAssessmentReportResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentReportRequest, DeleteAssessmentReportResponse> {
            serializer = DeleteAssessmentReportOperationSerializer()
            deserializer = DeleteAssessmentReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAssessmentReport"
            }
        }
        registerDeleteAssessmentReportMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom control in Audit Manager.
     */
    override suspend fun deleteControl(input: DeleteControlRequest): DeleteControlResponse {
        val op = SdkHttpOperation.build<DeleteControlRequest, DeleteControlResponse> {
            serializer = DeleteControlOperationSerializer()
            deserializer = DeleteControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteControl"
            }
        }
        registerDeleteControlMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters an account in Audit Manager.
     */
    override suspend fun deregisterAccount(input: DeregisterAccountRequest): DeregisterAccountResponse {
        val op = SdkHttpOperation.build<DeregisterAccountRequest, DeregisterAccountResponse> {
            serializer = DeregisterAccountOperationSerializer()
            deserializer = DeregisterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterAccount"
            }
        }
        registerDeregisterAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified member account as a delegated administrator for Audit Manager.
     * When you remove a delegated administrator from your Audit Manager settings, or when you
     * deregister a delegated administrator from Organizations, you continue to have access
     * to the evidence that you previously collected under that account. However, Audit Manager
     * will stop collecting and attaching evidence to that delegated administrator account
     * moving forward.
     */
    override suspend fun deregisterOrganizationAdminAccount(input: DeregisterOrganizationAdminAccountRequest): DeregisterOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<DeregisterOrganizationAdminAccountRequest, DeregisterOrganizationAdminAccountResponse> {
            serializer = DeregisterOrganizationAdminAccountOperationSerializer()
            deserializer = DeregisterOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterOrganizationAdminAccount"
            }
        }
        registerDeregisterOrganizationAdminAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an evidence folder from the specified assessment report in Audit Manager.
     */
    override suspend fun disassociateAssessmentReportEvidenceFolder(input: DisassociateAssessmentReportEvidenceFolderRequest): DisassociateAssessmentReportEvidenceFolderResponse {
        val op = SdkHttpOperation.build<DisassociateAssessmentReportEvidenceFolderRequest, DisassociateAssessmentReportEvidenceFolderResponse> {
            serializer = DisassociateAssessmentReportEvidenceFolderOperationSerializer()
            deserializer = DisassociateAssessmentReportEvidenceFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateAssessmentReportEvidenceFolder"
            }
        }
        registerDisassociateAssessmentReportEvidenceFolderMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the registration status of an account in Audit Manager.
     */
    override suspend fun getAccountStatus(input: GetAccountStatusRequest): GetAccountStatusResponse {
        val op = SdkHttpOperation.build<GetAccountStatusRequest, GetAccountStatusResponse> {
            serializer = GetAccountStatusOperationSerializer()
            deserializer = GetAccountStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccountStatus"
            }
        }
        registerGetAccountStatusMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an assessment from Audit Manager.
     */
    override suspend fun getAssessment(input: GetAssessmentRequest): GetAssessmentResponse {
        val op = SdkHttpOperation.build<GetAssessmentRequest, GetAssessmentResponse> {
            serializer = GetAssessmentOperationSerializer()
            deserializer = GetAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssessment"
            }
        }
        registerGetAssessmentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a framework from Audit Manager.
     */
    override suspend fun getAssessmentFramework(input: GetAssessmentFrameworkRequest): GetAssessmentFrameworkResponse {
        val op = SdkHttpOperation.build<GetAssessmentFrameworkRequest, GetAssessmentFrameworkResponse> {
            serializer = GetAssessmentFrameworkOperationSerializer()
            deserializer = GetAssessmentFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssessmentFramework"
            }
        }
        registerGetAssessmentFrameworkMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the URL of a specified assessment report in Audit Manager.
     */
    override suspend fun getAssessmentReportUrl(input: GetAssessmentReportUrlRequest): GetAssessmentReportUrlResponse {
        val op = SdkHttpOperation.build<GetAssessmentReportUrlRequest, GetAssessmentReportUrlResponse> {
            serializer = GetAssessmentReportUrlOperationSerializer()
            deserializer = GetAssessmentReportUrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssessmentReportUrl"
            }
        }
        registerGetAssessmentReportUrlMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of changelogs from Audit Manager.
     */
    override suspend fun getChangeLogs(input: GetChangeLogsRequest): GetChangeLogsResponse {
        val op = SdkHttpOperation.build<GetChangeLogsRequest, GetChangeLogsResponse> {
            serializer = GetChangeLogsOperationSerializer()
            deserializer = GetChangeLogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetChangeLogs"
            }
        }
        registerGetChangeLogsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a control from Audit Manager.
     */
    override suspend fun getControl(input: GetControlRequest): GetControlResponse {
        val op = SdkHttpOperation.build<GetControlRequest, GetControlResponse> {
            serializer = GetControlOperationSerializer()
            deserializer = GetControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetControl"
            }
        }
        registerGetControlMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of delegations from an audit owner to a delegate.
     */
    override suspend fun getDelegations(input: GetDelegationsRequest): GetDelegationsResponse {
        val op = SdkHttpOperation.build<GetDelegationsRequest, GetDelegationsResponse> {
            serializer = GetDelegationsOperationSerializer()
            deserializer = GetDelegationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDelegations"
            }
        }
        registerGetDelegationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns evidence from Audit Manager.
     */
    override suspend fun getEvidence(input: GetEvidenceRequest): GetEvidenceResponse {
        val op = SdkHttpOperation.build<GetEvidenceRequest, GetEvidenceResponse> {
            serializer = GetEvidenceOperationSerializer()
            deserializer = GetEvidenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEvidence"
            }
        }
        registerGetEvidenceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns all evidence from a specified evidence folder in Audit Manager.
     */
    override suspend fun getEvidenceByEvidenceFolder(input: GetEvidenceByEvidenceFolderRequest): GetEvidenceByEvidenceFolderResponse {
        val op = SdkHttpOperation.build<GetEvidenceByEvidenceFolderRequest, GetEvidenceByEvidenceFolderResponse> {
            serializer = GetEvidenceByEvidenceFolderOperationSerializer()
            deserializer = GetEvidenceByEvidenceFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEvidenceByEvidenceFolder"
            }
        }
        registerGetEvidenceByEvidenceFolderMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an evidence folder from the specified assessment in Audit Manager.
     */
    override suspend fun getEvidenceFolder(input: GetEvidenceFolderRequest): GetEvidenceFolderResponse {
        val op = SdkHttpOperation.build<GetEvidenceFolderRequest, GetEvidenceFolderResponse> {
            serializer = GetEvidenceFolderOperationSerializer()
            deserializer = GetEvidenceFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEvidenceFolder"
            }
        }
        registerGetEvidenceFolderMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the evidence folders from a specified assessment in Audit Manager.
     */
    override suspend fun getEvidenceFoldersByAssessment(input: GetEvidenceFoldersByAssessmentRequest): GetEvidenceFoldersByAssessmentResponse {
        val op = SdkHttpOperation.build<GetEvidenceFoldersByAssessmentRequest, GetEvidenceFoldersByAssessmentResponse> {
            serializer = GetEvidenceFoldersByAssessmentOperationSerializer()
            deserializer = GetEvidenceFoldersByAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEvidenceFoldersByAssessment"
            }
        }
        registerGetEvidenceFoldersByAssessmentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of evidence folders associated with a specified control of an assessment in Audit Manager.
     */
    override suspend fun getEvidenceFoldersByAssessmentControl(input: GetEvidenceFoldersByAssessmentControlRequest): GetEvidenceFoldersByAssessmentControlResponse {
        val op = SdkHttpOperation.build<GetEvidenceFoldersByAssessmentControlRequest, GetEvidenceFoldersByAssessmentControlResponse> {
            serializer = GetEvidenceFoldersByAssessmentControlOperationSerializer()
            deserializer = GetEvidenceFoldersByAssessmentControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEvidenceFoldersByAssessmentControl"
            }
        }
        registerGetEvidenceFoldersByAssessmentControlMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the name of the delegated Amazon Web Services administrator account for the organization.
     */
    override suspend fun getOrganizationAdminAccount(input: GetOrganizationAdminAccountRequest): GetOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<GetOrganizationAdminAccountRequest, GetOrganizationAdminAccountResponse> {
            serializer = GetOrganizationAdminAccountOperationSerializer()
            deserializer = GetOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOrganizationAdminAccount"
            }
        }
        registerGetOrganizationAdminAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the in-scope Amazon Web Services services for the specified assessment.
     */
    override suspend fun getServicesInScope(input: GetServicesInScopeRequest): GetServicesInScopeResponse {
        val op = SdkHttpOperation.build<GetServicesInScopeRequest, GetServicesInScopeResponse> {
            serializer = GetServicesInScopeOperationSerializer()
            deserializer = GetServicesInScopeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServicesInScope"
            }
        }
        registerGetServicesInScopeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the settings for the specified account.
     */
    override suspend fun getSettings(input: GetSettingsRequest): GetSettingsResponse {
        val op = SdkHttpOperation.build<GetSettingsRequest, GetSettingsResponse> {
            serializer = GetSettingsOperationSerializer()
            deserializer = GetSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSettings"
            }
        }
        registerGetSettingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the frameworks available in the Audit Manager framework library.
     */
    override suspend fun listAssessmentFrameworks(input: ListAssessmentFrameworksRequest): ListAssessmentFrameworksResponse {
        val op = SdkHttpOperation.build<ListAssessmentFrameworksRequest, ListAssessmentFrameworksResponse> {
            serializer = ListAssessmentFrameworksOperationSerializer()
            deserializer = ListAssessmentFrameworksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssessmentFrameworks"
            }
        }
        registerListAssessmentFrameworksMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of assessment reports created in Audit Manager.
     */
    override suspend fun listAssessmentReports(input: ListAssessmentReportsRequest): ListAssessmentReportsResponse {
        val op = SdkHttpOperation.build<ListAssessmentReportsRequest, ListAssessmentReportsResponse> {
            serializer = ListAssessmentReportsOperationSerializer()
            deserializer = ListAssessmentReportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssessmentReports"
            }
        }
        registerListAssessmentReportsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of current and past assessments from Audit Manager.
     */
    override suspend fun listAssessments(input: ListAssessmentsRequest): ListAssessmentsResponse {
        val op = SdkHttpOperation.build<ListAssessmentsRequest, ListAssessmentsResponse> {
            serializer = ListAssessmentsOperationSerializer()
            deserializer = ListAssessmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssessments"
            }
        }
        registerListAssessmentsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of controls from Audit Manager.
     */
    override suspend fun listControls(input: ListControlsRequest): ListControlsResponse {
        val op = SdkHttpOperation.build<ListControlsRequest, ListControlsResponse> {
            serializer = ListControlsOperationSerializer()
            deserializer = ListControlsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListControls"
            }
        }
        registerListControlsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of keywords that pre-mapped to the specified control data source.
     */
    override suspend fun listKeywordsForDataSource(input: ListKeywordsForDataSourceRequest): ListKeywordsForDataSourceResponse {
        val op = SdkHttpOperation.build<ListKeywordsForDataSourceRequest, ListKeywordsForDataSourceResponse> {
            serializer = ListKeywordsForDataSourceOperationSerializer()
            deserializer = ListKeywordsForDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListKeywordsForDataSource"
            }
        }
        registerListKeywordsForDataSourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all Audit Manager notifications.
     */
    override suspend fun listNotifications(input: ListNotificationsRequest): ListNotificationsResponse {
        val op = SdkHttpOperation.build<ListNotificationsRequest, ListNotificationsResponse> {
            serializer = ListNotificationsOperationSerializer()
            deserializer = ListNotificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNotifications"
            }
        }
        registerListNotificationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags for the specified resource in Audit Manager.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Enables Audit Manager for the specified account.
     */
    override suspend fun registerAccount(input: RegisterAccountRequest): RegisterAccountResponse {
        val op = SdkHttpOperation.build<RegisterAccountRequest, RegisterAccountResponse> {
            serializer = RegisterAccountOperationSerializer()
            deserializer = RegisterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterAccount"
            }
        }
        registerRegisterAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Enables an account within the organization as the delegated administrator for Audit Manager.
     */
    override suspend fun registerOrganizationAdminAccount(input: RegisterOrganizationAdminAccountRequest): RegisterOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<RegisterOrganizationAdminAccountRequest, RegisterOrganizationAdminAccountResponse> {
            serializer = RegisterOrganizationAdminAccountOperationSerializer()
            deserializer = RegisterOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterOrganizationAdminAccount"
            }
        }
        registerRegisterOrganizationAdminAccountMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Tags the specified resource in Audit Manager.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from a resource in Audit Manager.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Edits an Audit Manager assessment.
     */
    override suspend fun updateAssessment(input: UpdateAssessmentRequest): UpdateAssessmentResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentRequest, UpdateAssessmentResponse> {
            serializer = UpdateAssessmentOperationSerializer()
            deserializer = UpdateAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessment"
            }
        }
        registerUpdateAssessmentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a control within an assessment in Audit Manager.
     */
    override suspend fun updateAssessmentControl(input: UpdateAssessmentControlRequest): UpdateAssessmentControlResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentControlRequest, UpdateAssessmentControlResponse> {
            serializer = UpdateAssessmentControlOperationSerializer()
            deserializer = UpdateAssessmentControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessmentControl"
            }
        }
        registerUpdateAssessmentControlMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status of a control set in an Audit Manager assessment.
     */
    override suspend fun updateAssessmentControlSetStatus(input: UpdateAssessmentControlSetStatusRequest): UpdateAssessmentControlSetStatusResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentControlSetStatusRequest, UpdateAssessmentControlSetStatusResponse> {
            serializer = UpdateAssessmentControlSetStatusOperationSerializer()
            deserializer = UpdateAssessmentControlSetStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessmentControlSetStatus"
            }
        }
        registerUpdateAssessmentControlSetStatusMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a custom framework in Audit Manager.
     */
    override suspend fun updateAssessmentFramework(input: UpdateAssessmentFrameworkRequest): UpdateAssessmentFrameworkResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentFrameworkRequest, UpdateAssessmentFrameworkResponse> {
            serializer = UpdateAssessmentFrameworkOperationSerializer()
            deserializer = UpdateAssessmentFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessmentFramework"
            }
        }
        registerUpdateAssessmentFrameworkMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status of an assessment in Audit Manager.
     */
    override suspend fun updateAssessmentStatus(input: UpdateAssessmentStatusRequest): UpdateAssessmentStatusResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentStatusRequest, UpdateAssessmentStatusResponse> {
            serializer = UpdateAssessmentStatusOperationSerializer()
            deserializer = UpdateAssessmentStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessmentStatus"
            }
        }
        registerUpdateAssessmentStatusMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a custom control in Audit Manager.
     */
    override suspend fun updateControl(input: UpdateControlRequest): UpdateControlResponse {
        val op = SdkHttpOperation.build<UpdateControlRequest, UpdateControlResponse> {
            serializer = UpdateControlOperationSerializer()
            deserializer = UpdateControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateControl"
            }
        }
        registerUpdateControlMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates Audit Manager settings for the current user account.
     */
    override suspend fun updateSettings(input: UpdateSettingsRequest): UpdateSettingsResponse {
        val op = SdkHttpOperation.build<UpdateSettingsRequest, UpdateSettingsResponse> {
            serializer = UpdateSettingsOperationSerializer()
            deserializer = UpdateSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSettings"
            }
        }
        registerUpdateSettingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Validates the integrity of an assessment report in Audit Manager.
     */
    override suspend fun validateAssessmentReportIntegrity(input: ValidateAssessmentReportIntegrityRequest): ValidateAssessmentReportIntegrityResponse {
        val op = SdkHttpOperation.build<ValidateAssessmentReportIntegrityRequest, ValidateAssessmentReportIntegrityResponse> {
            serializer = ValidateAssessmentReportIntegrityOperationSerializer()
            deserializer = ValidateAssessmentReportIntegrityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ValidateAssessmentReportIntegrity"
            }
        }
        registerValidateAssessmentReportIntegrityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        val region = resolveRegionForOperation(ctx, config)
        ctx.putIfAbsent(AwsClientOption.Region, region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.signingRegion ?: region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
