// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.region.RegionConfig
import aws.sdk.kotlin.services.auditmanager.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * Welcome to the Audit Manager API reference. This guide is for developers who need detailed information about the Audit Manager API operations, data types, and errors.
 * Audit Manager is a service that provides automated evidence collection so that you
 * can continuously audit your Amazon Web Services usage, and assess the effectiveness of your controls to
 * better manage risk and simplify compliance.
 * Audit Manager provides pre-built frameworks that structure and automate assessments
 * for a given compliance standard. Frameworks include a pre-built collection of controls with
 * descriptions and testing procedures, which are grouped according to the requirements of the
 * specified compliance standard or regulation. You can also customize frameworks and controls
 * to support internal audits with unique requirements.
 * Use the following links to get started with the Audit Manager API:
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Operations.html">Actions: An alphabetical list of all Audit Manager API operations.
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Types.html">Data types: An alphabetical list of all Audit Manager data types.
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/CommonParameters.html">Common parameters: Parameters that all Query operations can use.
 * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/CommonErrors.html">Common errors: Client and server errors that all operations can return.
 * If you're new to Audit Manager, we recommend that you review the <a href="https://docs.aws.amazon.com/audit-manager/latest/userguide/what-is.html"> Audit Manager User Guide.
 */
interface AuditManagerClient : SdkClient {

    override val serviceName: String
        get() = "AuditManager"
    /**
     * AuditManagerClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): AuditManagerClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultAuditManagerClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String? = builder.region
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Associates an evidence folder to the specified assessment report in Audit Manager.
     */
    suspend fun associateAssessmentReportEvidenceFolder(input: AssociateAssessmentReportEvidenceFolderRequest): AssociateAssessmentReportEvidenceFolderResponse

    /**
     * Associates an evidence folder to the specified assessment report in Audit Manager.
     */
    suspend fun associateAssessmentReportEvidenceFolder(block: AssociateAssessmentReportEvidenceFolderRequest.DslBuilder.() -> Unit) = associateAssessmentReportEvidenceFolder(AssociateAssessmentReportEvidenceFolderRequest.builder().apply(block).build())

    /**
     * Associates a list of evidence to an assessment report in an Audit Manager assessment.
     */
    suspend fun batchAssociateAssessmentReportEvidence(input: BatchAssociateAssessmentReportEvidenceRequest): BatchAssociateAssessmentReportEvidenceResponse

    /**
     * Associates a list of evidence to an assessment report in an Audit Manager assessment.
     */
    suspend fun batchAssociateAssessmentReportEvidence(block: BatchAssociateAssessmentReportEvidenceRequest.DslBuilder.() -> Unit) = batchAssociateAssessmentReportEvidence(BatchAssociateAssessmentReportEvidenceRequest.builder().apply(block).build())

    /**
     * Create a batch of delegations for a specified assessment in Audit Manager.
     */
    suspend fun batchCreateDelegationByAssessment(input: BatchCreateDelegationByAssessmentRequest): BatchCreateDelegationByAssessmentResponse

    /**
     * Create a batch of delegations for a specified assessment in Audit Manager.
     */
    suspend fun batchCreateDelegationByAssessment(block: BatchCreateDelegationByAssessmentRequest.DslBuilder.() -> Unit) = batchCreateDelegationByAssessment(BatchCreateDelegationByAssessmentRequest.builder().apply(block).build())

    /**
     * Deletes the delegations in the specified Audit Manager assessment.
     */
    suspend fun batchDeleteDelegationByAssessment(input: BatchDeleteDelegationByAssessmentRequest): BatchDeleteDelegationByAssessmentResponse

    /**
     * Deletes the delegations in the specified Audit Manager assessment.
     */
    suspend fun batchDeleteDelegationByAssessment(block: BatchDeleteDelegationByAssessmentRequest.DslBuilder.() -> Unit) = batchDeleteDelegationByAssessment(BatchDeleteDelegationByAssessmentRequest.builder().apply(block).build())

    /**
     * Disassociates a list of evidence from the specified assessment report in Audit Manager.
     */
    suspend fun batchDisassociateAssessmentReportEvidence(input: BatchDisassociateAssessmentReportEvidenceRequest): BatchDisassociateAssessmentReportEvidenceResponse

    /**
     * Disassociates a list of evidence from the specified assessment report in Audit Manager.
     */
    suspend fun batchDisassociateAssessmentReportEvidence(block: BatchDisassociateAssessmentReportEvidenceRequest.DslBuilder.() -> Unit) = batchDisassociateAssessmentReportEvidence(BatchDisassociateAssessmentReportEvidenceRequest.builder().apply(block).build())

    /**
     * Uploads one or more pieces of evidence to the specified control in the assessment in Audit Manager.
     */
    suspend fun batchImportEvidenceToAssessmentControl(input: BatchImportEvidenceToAssessmentControlRequest): BatchImportEvidenceToAssessmentControlResponse

    /**
     * Uploads one or more pieces of evidence to the specified control in the assessment in Audit Manager.
     */
    suspend fun batchImportEvidenceToAssessmentControl(block: BatchImportEvidenceToAssessmentControlRequest.DslBuilder.() -> Unit) = batchImportEvidenceToAssessmentControl(BatchImportEvidenceToAssessmentControlRequest.builder().apply(block).build())

    /**
     * Creates an assessment in Audit Manager.
     */
    suspend fun createAssessment(input: CreateAssessmentRequest): CreateAssessmentResponse

    /**
     * Creates an assessment in Audit Manager.
     */
    suspend fun createAssessment(block: CreateAssessmentRequest.DslBuilder.() -> Unit) = createAssessment(CreateAssessmentRequest.builder().apply(block).build())

    /**
     * Creates a custom framework in Audit Manager.
     */
    suspend fun createAssessmentFramework(input: CreateAssessmentFrameworkRequest): CreateAssessmentFrameworkResponse

    /**
     * Creates a custom framework in Audit Manager.
     */
    suspend fun createAssessmentFramework(block: CreateAssessmentFrameworkRequest.DslBuilder.() -> Unit) = createAssessmentFramework(CreateAssessmentFrameworkRequest.builder().apply(block).build())

    /**
     * Creates an assessment report for the specified assessment.
     */
    suspend fun createAssessmentReport(input: CreateAssessmentReportRequest): CreateAssessmentReportResponse

    /**
     * Creates an assessment report for the specified assessment.
     */
    suspend fun createAssessmentReport(block: CreateAssessmentReportRequest.DslBuilder.() -> Unit) = createAssessmentReport(CreateAssessmentReportRequest.builder().apply(block).build())

    /**
     * Creates a new custom control in Audit Manager.
     */
    suspend fun createControl(input: CreateControlRequest): CreateControlResponse

    /**
     * Creates a new custom control in Audit Manager.
     */
    suspend fun createControl(block: CreateControlRequest.DslBuilder.() -> Unit) = createControl(CreateControlRequest.builder().apply(block).build())

    /**
     * Deletes an assessment in Audit Manager.
     */
    suspend fun deleteAssessment(input: DeleteAssessmentRequest): DeleteAssessmentResponse

    /**
     * Deletes an assessment in Audit Manager.
     */
    suspend fun deleteAssessment(block: DeleteAssessmentRequest.DslBuilder.() -> Unit) = deleteAssessment(DeleteAssessmentRequest.builder().apply(block).build())

    /**
     * Deletes a custom framework in Audit Manager.
     */
    suspend fun deleteAssessmentFramework(input: DeleteAssessmentFrameworkRequest): DeleteAssessmentFrameworkResponse

    /**
     * Deletes a custom framework in Audit Manager.
     */
    suspend fun deleteAssessmentFramework(block: DeleteAssessmentFrameworkRequest.DslBuilder.() -> Unit) = deleteAssessmentFramework(DeleteAssessmentFrameworkRequest.builder().apply(block).build())

    /**
     * Deletes an assessment report from an assessment in Audit Manager.
     */
    suspend fun deleteAssessmentReport(input: DeleteAssessmentReportRequest): DeleteAssessmentReportResponse

    /**
     * Deletes an assessment report from an assessment in Audit Manager.
     */
    suspend fun deleteAssessmentReport(block: DeleteAssessmentReportRequest.DslBuilder.() -> Unit) = deleteAssessmentReport(DeleteAssessmentReportRequest.builder().apply(block).build())

    /**
     * Deletes a custom control in Audit Manager.
     */
    suspend fun deleteControl(input: DeleteControlRequest): DeleteControlResponse

    /**
     * Deletes a custom control in Audit Manager.
     */
    suspend fun deleteControl(block: DeleteControlRequest.DslBuilder.() -> Unit) = deleteControl(DeleteControlRequest.builder().apply(block).build())

    /**
     * Deregisters an account in Audit Manager.
     */
    suspend fun deregisterAccount(input: DeregisterAccountRequest): DeregisterAccountResponse

    /**
     * Deregisters an account in Audit Manager.
     */
    suspend fun deregisterAccount(block: DeregisterAccountRequest.DslBuilder.() -> Unit) = deregisterAccount(DeregisterAccountRequest.builder().apply(block).build())

    /**
     * Removes the specified member account as a delegated administrator for Audit Manager.
     * When you remove a delegated administrator from your Audit Manager settings, or when you
     * deregister a delegated administrator from Organizations, you continue to have access
     * to the evidence that you previously collected under that account. However, Audit Manager
     * will stop collecting and attaching evidence to that delegated administrator account
     * moving forward.
     */
    suspend fun deregisterOrganizationAdminAccount(input: DeregisterOrganizationAdminAccountRequest): DeregisterOrganizationAdminAccountResponse

    /**
     * Removes the specified member account as a delegated administrator for Audit Manager.
     * When you remove a delegated administrator from your Audit Manager settings, or when you
     * deregister a delegated administrator from Organizations, you continue to have access
     * to the evidence that you previously collected under that account. However, Audit Manager
     * will stop collecting and attaching evidence to that delegated administrator account
     * moving forward.
     */
    suspend fun deregisterOrganizationAdminAccount(block: DeregisterOrganizationAdminAccountRequest.DslBuilder.() -> Unit) = deregisterOrganizationAdminAccount(DeregisterOrganizationAdminAccountRequest.builder().apply(block).build())

    /**
     * Disassociates an evidence folder from the specified assessment report in Audit Manager.
     */
    suspend fun disassociateAssessmentReportEvidenceFolder(input: DisassociateAssessmentReportEvidenceFolderRequest): DisassociateAssessmentReportEvidenceFolderResponse

    /**
     * Disassociates an evidence folder from the specified assessment report in Audit Manager.
     */
    suspend fun disassociateAssessmentReportEvidenceFolder(block: DisassociateAssessmentReportEvidenceFolderRequest.DslBuilder.() -> Unit) = disassociateAssessmentReportEvidenceFolder(DisassociateAssessmentReportEvidenceFolderRequest.builder().apply(block).build())

    /**
     * Returns the registration status of an account in Audit Manager.
     */
    suspend fun getAccountStatus(input: GetAccountStatusRequest): GetAccountStatusResponse

    /**
     * Returns the registration status of an account in Audit Manager.
     */
    suspend fun getAccountStatus(block: GetAccountStatusRequest.DslBuilder.() -> Unit) = getAccountStatus(GetAccountStatusRequest.builder().apply(block).build())

    /**
     * Returns an assessment from Audit Manager.
     */
    suspend fun getAssessment(input: GetAssessmentRequest): GetAssessmentResponse

    /**
     * Returns an assessment from Audit Manager.
     */
    suspend fun getAssessment(block: GetAssessmentRequest.DslBuilder.() -> Unit) = getAssessment(GetAssessmentRequest.builder().apply(block).build())

    /**
     * Returns a framework from Audit Manager.
     */
    suspend fun getAssessmentFramework(input: GetAssessmentFrameworkRequest): GetAssessmentFrameworkResponse

    /**
     * Returns a framework from Audit Manager.
     */
    suspend fun getAssessmentFramework(block: GetAssessmentFrameworkRequest.DslBuilder.() -> Unit) = getAssessmentFramework(GetAssessmentFrameworkRequest.builder().apply(block).build())

    /**
     * Returns the URL of a specified assessment report in Audit Manager.
     */
    suspend fun getAssessmentReportUrl(input: GetAssessmentReportUrlRequest): GetAssessmentReportUrlResponse

    /**
     * Returns the URL of a specified assessment report in Audit Manager.
     */
    suspend fun getAssessmentReportUrl(block: GetAssessmentReportUrlRequest.DslBuilder.() -> Unit) = getAssessmentReportUrl(GetAssessmentReportUrlRequest.builder().apply(block).build())

    /**
     * Returns a list of changelogs from Audit Manager.
     */
    suspend fun getChangeLogs(input: GetChangeLogsRequest): GetChangeLogsResponse

    /**
     * Returns a list of changelogs from Audit Manager.
     */
    suspend fun getChangeLogs(block: GetChangeLogsRequest.DslBuilder.() -> Unit) = getChangeLogs(GetChangeLogsRequest.builder().apply(block).build())

    /**
     * Returns a control from Audit Manager.
     */
    suspend fun getControl(input: GetControlRequest): GetControlResponse

    /**
     * Returns a control from Audit Manager.
     */
    suspend fun getControl(block: GetControlRequest.DslBuilder.() -> Unit) = getControl(GetControlRequest.builder().apply(block).build())

    /**
     * Returns a list of delegations from an audit owner to a delegate.
     */
    suspend fun getDelegations(input: GetDelegationsRequest): GetDelegationsResponse

    /**
     * Returns a list of delegations from an audit owner to a delegate.
     */
    suspend fun getDelegations(block: GetDelegationsRequest.DslBuilder.() -> Unit) = getDelegations(GetDelegationsRequest.builder().apply(block).build())

    /**
     * Returns evidence from Audit Manager.
     */
    suspend fun getEvidence(input: GetEvidenceRequest): GetEvidenceResponse

    /**
     * Returns evidence from Audit Manager.
     */
    suspend fun getEvidence(block: GetEvidenceRequest.DslBuilder.() -> Unit) = getEvidence(GetEvidenceRequest.builder().apply(block).build())

    /**
     * Returns all evidence from a specified evidence folder in Audit Manager.
     */
    suspend fun getEvidenceByEvidenceFolder(input: GetEvidenceByEvidenceFolderRequest): GetEvidenceByEvidenceFolderResponse

    /**
     * Returns all evidence from a specified evidence folder in Audit Manager.
     */
    suspend fun getEvidenceByEvidenceFolder(block: GetEvidenceByEvidenceFolderRequest.DslBuilder.() -> Unit) = getEvidenceByEvidenceFolder(GetEvidenceByEvidenceFolderRequest.builder().apply(block).build())

    /**
     * Returns an evidence folder from the specified assessment in Audit Manager.
     */
    suspend fun getEvidenceFolder(input: GetEvidenceFolderRequest): GetEvidenceFolderResponse

    /**
     * Returns an evidence folder from the specified assessment in Audit Manager.
     */
    suspend fun getEvidenceFolder(block: GetEvidenceFolderRequest.DslBuilder.() -> Unit) = getEvidenceFolder(GetEvidenceFolderRequest.builder().apply(block).build())

    /**
     * Returns the evidence folders from a specified assessment in Audit Manager.
     */
    suspend fun getEvidenceFoldersByAssessment(input: GetEvidenceFoldersByAssessmentRequest): GetEvidenceFoldersByAssessmentResponse

    /**
     * Returns the evidence folders from a specified assessment in Audit Manager.
     */
    suspend fun getEvidenceFoldersByAssessment(block: GetEvidenceFoldersByAssessmentRequest.DslBuilder.() -> Unit) = getEvidenceFoldersByAssessment(GetEvidenceFoldersByAssessmentRequest.builder().apply(block).build())

    /**
     * Returns a list of evidence folders associated with a specified control of an assessment in Audit Manager.
     */
    suspend fun getEvidenceFoldersByAssessmentControl(input: GetEvidenceFoldersByAssessmentControlRequest): GetEvidenceFoldersByAssessmentControlResponse

    /**
     * Returns a list of evidence folders associated with a specified control of an assessment in Audit Manager.
     */
    suspend fun getEvidenceFoldersByAssessmentControl(block: GetEvidenceFoldersByAssessmentControlRequest.DslBuilder.() -> Unit) = getEvidenceFoldersByAssessmentControl(GetEvidenceFoldersByAssessmentControlRequest.builder().apply(block).build())

    /**
     * Returns the name of the delegated Amazon Web Services administrator account for the organization.
     */
    suspend fun getOrganizationAdminAccount(input: GetOrganizationAdminAccountRequest): GetOrganizationAdminAccountResponse

    /**
     * Returns the name of the delegated Amazon Web Services administrator account for the organization.
     */
    suspend fun getOrganizationAdminAccount(block: GetOrganizationAdminAccountRequest.DslBuilder.() -> Unit) = getOrganizationAdminAccount(GetOrganizationAdminAccountRequest.builder().apply(block).build())

    /**
     * Returns a list of the in-scope Amazon Web Services services for the specified assessment.
     */
    suspend fun getServicesInScope(input: GetServicesInScopeRequest): GetServicesInScopeResponse

    /**
     * Returns a list of the in-scope Amazon Web Services services for the specified assessment.
     */
    suspend fun getServicesInScope(block: GetServicesInScopeRequest.DslBuilder.() -> Unit) = getServicesInScope(GetServicesInScopeRequest.builder().apply(block).build())

    /**
     * Returns the settings for the specified account.
     */
    suspend fun getSettings(input: GetSettingsRequest): GetSettingsResponse

    /**
     * Returns the settings for the specified account.
     */
    suspend fun getSettings(block: GetSettingsRequest.DslBuilder.() -> Unit) = getSettings(GetSettingsRequest.builder().apply(block).build())

    /**
     * Returns a list of the frameworks available in the Audit Manager framework library.
     */
    suspend fun listAssessmentFrameworks(input: ListAssessmentFrameworksRequest): ListAssessmentFrameworksResponse

    /**
     * Returns a list of the frameworks available in the Audit Manager framework library.
     */
    suspend fun listAssessmentFrameworks(block: ListAssessmentFrameworksRequest.DslBuilder.() -> Unit) = listAssessmentFrameworks(ListAssessmentFrameworksRequest.builder().apply(block).build())

    /**
     * Returns a list of assessment reports created in Audit Manager.
     */
    suspend fun listAssessmentReports(input: ListAssessmentReportsRequest): ListAssessmentReportsResponse

    /**
     * Returns a list of assessment reports created in Audit Manager.
     */
    suspend fun listAssessmentReports(block: ListAssessmentReportsRequest.DslBuilder.() -> Unit) = listAssessmentReports(ListAssessmentReportsRequest.builder().apply(block).build())

    /**
     * Returns a list of current and past assessments from Audit Manager.
     */
    suspend fun listAssessments(input: ListAssessmentsRequest): ListAssessmentsResponse

    /**
     * Returns a list of current and past assessments from Audit Manager.
     */
    suspend fun listAssessments(block: ListAssessmentsRequest.DslBuilder.() -> Unit) = listAssessments(ListAssessmentsRequest.builder().apply(block).build())

    /**
     * Returns a list of controls from Audit Manager.
     */
    suspend fun listControls(input: ListControlsRequest): ListControlsResponse

    /**
     * Returns a list of controls from Audit Manager.
     */
    suspend fun listControls(block: ListControlsRequest.DslBuilder.() -> Unit) = listControls(ListControlsRequest.builder().apply(block).build())

    /**
     * Returns a list of keywords that pre-mapped to the specified control data source.
     */
    suspend fun listKeywordsForDataSource(input: ListKeywordsForDataSourceRequest): ListKeywordsForDataSourceResponse

    /**
     * Returns a list of keywords that pre-mapped to the specified control data source.
     */
    suspend fun listKeywordsForDataSource(block: ListKeywordsForDataSourceRequest.DslBuilder.() -> Unit) = listKeywordsForDataSource(ListKeywordsForDataSourceRequest.builder().apply(block).build())

    /**
     * Returns a list of all Audit Manager notifications.
     */
    suspend fun listNotifications(input: ListNotificationsRequest): ListNotificationsResponse

    /**
     * Returns a list of all Audit Manager notifications.
     */
    suspend fun listNotifications(block: ListNotificationsRequest.DslBuilder.() -> Unit) = listNotifications(ListNotificationsRequest.builder().apply(block).build())

    /**
     * Returns a list of tags for the specified resource in Audit Manager.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of tags for the specified resource in Audit Manager.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Enables Audit Manager for the specified account.
     */
    suspend fun registerAccount(input: RegisterAccountRequest): RegisterAccountResponse

    /**
     * Enables Audit Manager for the specified account.
     */
    suspend fun registerAccount(block: RegisterAccountRequest.DslBuilder.() -> Unit) = registerAccount(RegisterAccountRequest.builder().apply(block).build())

    /**
     * Enables an account within the organization as the delegated administrator for Audit Manager.
     */
    suspend fun registerOrganizationAdminAccount(input: RegisterOrganizationAdminAccountRequest): RegisterOrganizationAdminAccountResponse

    /**
     * Enables an account within the organization as the delegated administrator for Audit Manager.
     */
    suspend fun registerOrganizationAdminAccount(block: RegisterOrganizationAdminAccountRequest.DslBuilder.() -> Unit) = registerOrganizationAdminAccount(RegisterOrganizationAdminAccountRequest.builder().apply(block).build())

    /**
     * Tags the specified resource in Audit Manager.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tags the specified resource in Audit Manager.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes a tag from a resource in Audit Manager.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from a resource in Audit Manager.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Edits an Audit Manager assessment.
     */
    suspend fun updateAssessment(input: UpdateAssessmentRequest): UpdateAssessmentResponse

    /**
     * Edits an Audit Manager assessment.
     */
    suspend fun updateAssessment(block: UpdateAssessmentRequest.DslBuilder.() -> Unit) = updateAssessment(UpdateAssessmentRequest.builder().apply(block).build())

    /**
     * Updates a control within an assessment in Audit Manager.
     */
    suspend fun updateAssessmentControl(input: UpdateAssessmentControlRequest): UpdateAssessmentControlResponse

    /**
     * Updates a control within an assessment in Audit Manager.
     */
    suspend fun updateAssessmentControl(block: UpdateAssessmentControlRequest.DslBuilder.() -> Unit) = updateAssessmentControl(UpdateAssessmentControlRequest.builder().apply(block).build())

    /**
     * Updates the status of a control set in an Audit Manager assessment.
     */
    suspend fun updateAssessmentControlSetStatus(input: UpdateAssessmentControlSetStatusRequest): UpdateAssessmentControlSetStatusResponse

    /**
     * Updates the status of a control set in an Audit Manager assessment.
     */
    suspend fun updateAssessmentControlSetStatus(block: UpdateAssessmentControlSetStatusRequest.DslBuilder.() -> Unit) = updateAssessmentControlSetStatus(UpdateAssessmentControlSetStatusRequest.builder().apply(block).build())

    /**
     * Updates a custom framework in Audit Manager.
     */
    suspend fun updateAssessmentFramework(input: UpdateAssessmentFrameworkRequest): UpdateAssessmentFrameworkResponse

    /**
     * Updates a custom framework in Audit Manager.
     */
    suspend fun updateAssessmentFramework(block: UpdateAssessmentFrameworkRequest.DslBuilder.() -> Unit) = updateAssessmentFramework(UpdateAssessmentFrameworkRequest.builder().apply(block).build())

    /**
     * Updates the status of an assessment in Audit Manager.
     */
    suspend fun updateAssessmentStatus(input: UpdateAssessmentStatusRequest): UpdateAssessmentStatusResponse

    /**
     * Updates the status of an assessment in Audit Manager.
     */
    suspend fun updateAssessmentStatus(block: UpdateAssessmentStatusRequest.DslBuilder.() -> Unit) = updateAssessmentStatus(UpdateAssessmentStatusRequest.builder().apply(block).build())

    /**
     * Updates a custom control in Audit Manager.
     */
    suspend fun updateControl(input: UpdateControlRequest): UpdateControlResponse

    /**
     * Updates a custom control in Audit Manager.
     */
    suspend fun updateControl(block: UpdateControlRequest.DslBuilder.() -> Unit) = updateControl(UpdateControlRequest.builder().apply(block).build())

    /**
     * Updates Audit Manager settings for the current user account.
     */
    suspend fun updateSettings(input: UpdateSettingsRequest): UpdateSettingsResponse

    /**
     * Updates Audit Manager settings for the current user account.
     */
    suspend fun updateSettings(block: UpdateSettingsRequest.DslBuilder.() -> Unit) = updateSettings(UpdateSettingsRequest.builder().apply(block).build())

    /**
     * Validates the integrity of an assessment report in Audit Manager.
     */
    suspend fun validateAssessmentReportIntegrity(input: ValidateAssessmentReportIntegrityRequest): ValidateAssessmentReportIntegrityResponse

    /**
     * Validates the integrity of an assessment report in Audit Manager.
     */
    suspend fun validateAssessmentReportIntegrity(block: ValidateAssessmentReportIntegrityRequest.DslBuilder.() -> Unit) = validateAssessmentReportIntegrity(ValidateAssessmentReportIntegrityRequest.builder().apply(block).build())
}
