// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.serde

import aws.sdk.kotlin.services.athena.model.AthenaException
import aws.sdk.kotlin.services.athena.model.BatchGetPreparedStatementResponse
import aws.sdk.kotlin.services.athena.model.PreparedStatement
import aws.sdk.kotlin.services.athena.model.UnprocessedPreparedStatementName
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetPreparedStatementOperationDeserializer: HttpDeserialize<BatchGetPreparedStatementResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): BatchGetPreparedStatementResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetPreparedStatementError(context, call)
        }
        val builder = BatchGetPreparedStatementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetPreparedStatementOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwBatchGetPreparedStatementError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AthenaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AthenaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetPreparedStatementOperationBody(builder: BatchGetPreparedStatementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PREPAREDSTATEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PreparedStatements"))
    val UNPROCESSEDPREPAREDSTATEMENTNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedPreparedStatementNames"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PREPAREDSTATEMENTS_DESCRIPTOR)
        field(UNPROCESSEDPREPAREDSTATEMENTNAMES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PREPAREDSTATEMENTS_DESCRIPTOR.index -> builder.preparedStatements =
                    deserializer.deserializeList(PREPAREDSTATEMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<PreparedStatement>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePreparedStatementDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDPREPAREDSTATEMENTNAMES_DESCRIPTOR.index -> builder.unprocessedPreparedStatementNames =
                    deserializer.deserializeList(UNPROCESSEDPREPAREDSTATEMENTNAMES_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedPreparedStatementName>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedPreparedStatementNameDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
