// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A workgroup, which contains a name, description, creation time, state, and other configuration, listed under WorkGroup$Configuration. Each workgroup enables you to isolate queries for you or your group of users from other queries in the same account, to configure the query results location and the encryption configuration (known as workgroup settings), to enable sending query metrics to Amazon CloudWatch, and to establish per-query data usage control limits for all queries in a workgroup. The workgroup settings override is specified in `EnforceWorkGroupConfiguration` (true/false) in the `WorkGroupConfiguration`. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
 */
public class WorkGroup private constructor(builder: Builder) {
    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query and calculation results are stored, the encryption configuration, if any, used for query and calculation results; whether the Amazon CloudWatch Metrics are enabled for the workgroup; whether workgroup settings override client-side settings; and the data usage limits for the amount of data scanned per query or per workgroup. The workgroup settings override is specified in `EnforceWorkGroupConfiguration` (true/false) in the `WorkGroupConfiguration`. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
     */
    public val configuration: aws.sdk.kotlin.services.athena.model.WorkGroupConfiguration? = builder.configuration
    /**
     * The date and time the workgroup was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The workgroup description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The workgroup name.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The state of the workgroup: ENABLED or DISABLED.
     */
    public val state: aws.sdk.kotlin.services.athena.model.WorkGroupState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.WorkGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkGroup(")
        append("configuration=$configuration,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("name=$name,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkGroup

        if (configuration != other.configuration) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.WorkGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration of the workgroup, which includes the location in Amazon S3 where query and calculation results are stored, the encryption configuration, if any, used for query and calculation results; whether the Amazon CloudWatch Metrics are enabled for the workgroup; whether workgroup settings override client-side settings; and the data usage limits for the amount of data scanned per query or per workgroup. The workgroup settings override is specified in `EnforceWorkGroupConfiguration` (true/false) in the `WorkGroupConfiguration`. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
         */
        public var configuration: aws.sdk.kotlin.services.athena.model.WorkGroupConfiguration? = null
        /**
         * The date and time the workgroup was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The workgroup description.
         */
        public var description: kotlin.String? = null
        /**
         * The workgroup name.
         */
        public var name: kotlin.String? = null
        /**
         * The state of the workgroup: ENABLED or DISABLED.
         */
        public var state: aws.sdk.kotlin.services.athena.model.WorkGroupState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.WorkGroup) : this() {
            this.configuration = x.configuration
            this.creationTime = x.creationTime
            this.description = x.description
            this.name = x.name
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.WorkGroup = WorkGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.WorkGroupConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.athena.model.WorkGroupConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.athena.model.WorkGroupConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
