// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



public class UpdateNotebookRequest private constructor(builder: Builder) {
    /**
     * A unique case-sensitive string used to ensure the request to create the notebook is idempotent (executes only once).
     *
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The ID of the notebook to update.
     */
    public val notebookId: kotlin.String? = builder.notebookId
    /**
     * The updated content for the notebook.
     */
    public val payload: kotlin.String? = builder.payload
    /**
     * The active notebook session ID. Required if the notebook has an active session.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * The notebook content type. Currently, the only valid type is `IPYNB`.
     */
    public val type: aws.sdk.kotlin.services.athena.model.NotebookType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.UpdateNotebookRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateNotebookRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("notebookId=$notebookId,")
        append("payload=$payload,")
        append("sessionId=$sessionId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (notebookId?.hashCode() ?: 0)
        result = 31 * result + (payload?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateNotebookRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (notebookId != other.notebookId) return false
        if (payload != other.payload) return false
        if (sessionId != other.sessionId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.UpdateNotebookRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique case-sensitive string used to ensure the request to create the notebook is idempotent (executes only once).
         *
         * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The ID of the notebook to update.
         */
        public var notebookId: kotlin.String? = null
        /**
         * The updated content for the notebook.
         */
        public var payload: kotlin.String? = null
        /**
         * The active notebook session ID. Required if the notebook has an active session.
         */
        public var sessionId: kotlin.String? = null
        /**
         * The notebook content type. Currently, the only valid type is `IPYNB`.
         */
        public var type: aws.sdk.kotlin.services.athena.model.NotebookType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.UpdateNotebookRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.notebookId = x.notebookId
            this.payload = x.payload
            this.sessionId = x.sessionId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.UpdateNotebookRequest = UpdateNotebookRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
