// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



public class StartSessionResponse private constructor(builder: Builder) {
    /**
     * The session ID.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * The state of the session. A description of each state follows.
     *
     * `CREATING` - The session is being started, including acquiring resources.
     *
     * `CREATED` - The session has been started.
     *
     * `IDLE` - The session is able to accept a calculation.
     *
     * `BUSY` - The session is processing another task and is unable to accept a calculation.
     *
     * `TERMINATING` - The session is in the process of shutting down.
     *
     * `TERMINATED` - The session and its resources are no longer running.
     *
     * `DEGRADED` - The session has no healthy coordinators.
     *
     * `FAILED` - Due to a failure, the session and its resources are no longer running.
     */
    public val state: aws.sdk.kotlin.services.athena.model.SessionState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.StartSessionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSessionResponse(")
        append("sessionId=$sessionId,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sessionId?.hashCode() ?: 0
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSessionResponse

        if (sessionId != other.sessionId) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.StartSessionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The session ID.
         */
        public var sessionId: kotlin.String? = null
        /**
         * The state of the session. A description of each state follows.
         *
         * `CREATING` - The session is being started, including acquiring resources.
         *
         * `CREATED` - The session has been started.
         *
         * `IDLE` - The session is able to accept a calculation.
         *
         * `BUSY` - The session is processing another task and is unable to accept a calculation.
         *
         * `TERMINATING` - The session is in the process of shutting down.
         *
         * `TERMINATED` - The session and its resources are no longer running.
         *
         * `DEGRADED` - The session has no healthy coordinators.
         *
         * `FAILED` - Due to a failure, the session and its resources are no longer running.
         */
        public var state: aws.sdk.kotlin.services.athena.model.SessionState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.StartSessionResponse) : this() {
            this.sessionId = x.sessionId
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.StartSessionResponse = StartSessionResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
