// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



public class StartQueryExecutionRequest private constructor(builder: Builder) {
    /**
     * A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another `StartQueryExecution` request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the `QueryString`, an error is returned.
     *
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * A list of values for the parameters in a query. The values are applied sequentially to the parameters in the query in the order in which the parameters occur.
     */
    public val executionParameters: List<String>? = builder.executionParameters
    /**
     * The database within which the query executes.
     */
    public val queryExecutionContext: aws.sdk.kotlin.services.athena.model.QueryExecutionContext? = builder.queryExecutionContext
    /**
     * The SQL query statements to be executed.
     */
    public val queryString: kotlin.String? = builder.queryString
    /**
     * Specifies information about where and how to save the results of the query execution. If the query runs in a workgroup, then workgroup's settings may override query settings. This affects the query results location. The workgroup settings override is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
     */
    public val resultConfiguration: aws.sdk.kotlin.services.athena.model.ResultConfiguration? = builder.resultConfiguration
    /**
     * Specifies the query result reuse behavior for the query.
     */
    public val resultReuseConfiguration: aws.sdk.kotlin.services.athena.model.ResultReuseConfiguration? = builder.resultReuseConfiguration
    /**
     * The name of the workgroup in which the query is being started.
     */
    public val workGroup: kotlin.String? = builder.workGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.StartQueryExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartQueryExecutionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("executionParameters=$executionParameters,")
        append("queryExecutionContext=$queryExecutionContext,")
        append("queryString=$queryString,")
        append("resultConfiguration=$resultConfiguration,")
        append("resultReuseConfiguration=$resultReuseConfiguration,")
        append("workGroup=$workGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (executionParameters?.hashCode() ?: 0)
        result = 31 * result + (queryExecutionContext?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (resultConfiguration?.hashCode() ?: 0)
        result = 31 * result + (resultReuseConfiguration?.hashCode() ?: 0)
        result = 31 * result + (workGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartQueryExecutionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (executionParameters != other.executionParameters) return false
        if (queryExecutionContext != other.queryExecutionContext) return false
        if (queryString != other.queryString) return false
        if (resultConfiguration != other.resultConfiguration) return false
        if (resultReuseConfiguration != other.resultReuseConfiguration) return false
        if (workGroup != other.workGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.StartQueryExecutionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another `StartQueryExecution` request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the `QueryString`, an error is returned.
         *
         * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * A list of values for the parameters in a query. The values are applied sequentially to the parameters in the query in the order in which the parameters occur.
         */
        public var executionParameters: List<String>? = null
        /**
         * The database within which the query executes.
         */
        public var queryExecutionContext: aws.sdk.kotlin.services.athena.model.QueryExecutionContext? = null
        /**
         * The SQL query statements to be executed.
         */
        public var queryString: kotlin.String? = null
        /**
         * Specifies information about where and how to save the results of the query execution. If the query runs in a workgroup, then workgroup's settings may override query settings. This affects the query results location. The workgroup settings override is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
         */
        public var resultConfiguration: aws.sdk.kotlin.services.athena.model.ResultConfiguration? = null
        /**
         * Specifies the query result reuse behavior for the query.
         */
        public var resultReuseConfiguration: aws.sdk.kotlin.services.athena.model.ResultReuseConfiguration? = null
        /**
         * The name of the workgroup in which the query is being started.
         */
        public var workGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.StartQueryExecutionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.executionParameters = x.executionParameters
            this.queryExecutionContext = x.queryExecutionContext
            this.queryString = x.queryString
            this.resultConfiguration = x.resultConfiguration
            this.resultReuseConfiguration = x.resultReuseConfiguration
            this.workGroup = x.workGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.StartQueryExecutionRequest = StartQueryExecutionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.QueryExecutionContext] inside the given [block]
         */
        public fun queryExecutionContext(block: aws.sdk.kotlin.services.athena.model.QueryExecutionContext.Builder.() -> kotlin.Unit) {
            this.queryExecutionContext = aws.sdk.kotlin.services.athena.model.QueryExecutionContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.ResultConfiguration] inside the given [block]
         */
        public fun resultConfiguration(block: aws.sdk.kotlin.services.athena.model.ResultConfiguration.Builder.() -> kotlin.Unit) {
            this.resultConfiguration = aws.sdk.kotlin.services.athena.model.ResultConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.ResultReuseConfiguration] inside the given [block]
         */
        public fun resultReuseConfiguration(block: aws.sdk.kotlin.services.athena.model.ResultReuseConfiguration.Builder.() -> kotlin.Unit) {
            this.resultReuseConfiguration = aws.sdk.kotlin.services.athena.model.ResultReuseConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
