// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Specifies whether previous query results are reused, and if so, their maximum age.
 */
public class ResultReuseByAgeConfiguration private constructor(builder: Builder) {
    /**
     * True if previous query results can be reused when the query is run; otherwise, false. The default is false.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * Specifies, in minutes, the maximum age of a previous query result that Athena should consider for reuse. The default is 60.
     */
    public val maxAgeInMinutes: kotlin.Int? = builder.maxAgeInMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.ResultReuseByAgeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResultReuseByAgeConfiguration(")
        append("enabled=$enabled,")
        append("maxAgeInMinutes=$maxAgeInMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (maxAgeInMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResultReuseByAgeConfiguration

        if (enabled != other.enabled) return false
        if (maxAgeInMinutes != other.maxAgeInMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.ResultReuseByAgeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * True if previous query results can be reused when the query is run; otherwise, false. The default is false.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * Specifies, in minutes, the maximum age of a previous query result that Athena should consider for reuse. The default is 60.
         */
        public var maxAgeInMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.ResultReuseByAgeConfiguration) : this() {
            this.enabled = x.enabled
            this.maxAgeInMinutes = x.maxAgeInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.ResultReuseByAgeConfiguration = ResultReuseByAgeConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
