// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * The information about the updates in the query results, such as output location and encryption configuration for the query results.
 */
public class ResultConfigurationUpdates private constructor(builder: Builder) {
    /**
     * The ACL configuration for the query results.
     */
    public val aclConfiguration: aws.sdk.kotlin.services.athena.model.AclConfiguration? = builder.aclConfiguration
    /**
     * The encryption configuration for query and calculation results.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.athena.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The Amazon Web Services account ID that you expect to be the owner of the Amazon S3 bucket specified by ResultConfiguration$OutputLocation. If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` Amazon Web Services account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
     *
     * If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See WorkGroupConfiguration$EnforceWorkGroupConfiguration and [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * The location in Amazon S3 where your query and calculation results are stored, such as `s3://path/to/query/bucket/`. For more information, see [Working with query results, recent queries, and output files](https://docs.aws.amazon.com/athena/latest/ug/querying.html). If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in `EnforceWorkGroupConfiguration` (true/false) in the `WorkGroupConfiguration`. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
     */
    public val outputLocation: kotlin.String? = builder.outputLocation
    /**
     * If set to `true`, indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null. If set to `false` or not set, and a value is present in the `AclConfiguration` of `ResultConfigurationUpdates`, the `AclConfiguration` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
     */
    public val removeAclConfiguration: kotlin.Boolean? = builder.removeAclConfiguration
    /**
     * If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the `EncryptionConfiguration` in `ResultConfigurationUpdates` (the client-side setting), the `EncryptionConfiguration` in the workgroup's `ResultConfiguration` will be updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
     */
    public val removeEncryptionConfiguration: kotlin.Boolean? = builder.removeEncryptionConfiguration
    /**
     * If set to "true", removes the Amazon Web Services account ID previously specified for ResultConfiguration$ExpectedBucketOwner. If set to "false" or not set, and a value is present in the `ExpectedBucketOwner` in `ResultConfigurationUpdates` (the client-side setting), the `ExpectedBucketOwner` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
     */
    public val removeExpectedBucketOwner: kotlin.Boolean? = builder.removeExpectedBucketOwner
    /**
     * If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the `OutputLocation` in `ResultConfigurationUpdates` (the client-side setting), the `OutputLocation` in the workgroup's `ResultConfiguration` will be updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
     */
    public val removeOutputLocation: kotlin.Boolean? = builder.removeOutputLocation

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResultConfigurationUpdates(")
        append("aclConfiguration=$aclConfiguration,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("outputLocation=$outputLocation,")
        append("removeAclConfiguration=$removeAclConfiguration,")
        append("removeEncryptionConfiguration=$removeEncryptionConfiguration,")
        append("removeExpectedBucketOwner=$removeExpectedBucketOwner,")
        append("removeOutputLocation=$removeOutputLocation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aclConfiguration?.hashCode() ?: 0
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (removeAclConfiguration?.hashCode() ?: 0)
        result = 31 * result + (removeEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (removeExpectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (removeOutputLocation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResultConfigurationUpdates

        if (aclConfiguration != other.aclConfiguration) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (outputLocation != other.outputLocation) return false
        if (removeAclConfiguration != other.removeAclConfiguration) return false
        if (removeEncryptionConfiguration != other.removeEncryptionConfiguration) return false
        if (removeExpectedBucketOwner != other.removeExpectedBucketOwner) return false
        if (removeOutputLocation != other.removeOutputLocation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ACL configuration for the query results.
         */
        public var aclConfiguration: aws.sdk.kotlin.services.athena.model.AclConfiguration? = null
        /**
         * The encryption configuration for query and calculation results.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.athena.model.EncryptionConfiguration? = null
        /**
         * The Amazon Web Services account ID that you expect to be the owner of the Amazon S3 bucket specified by ResultConfiguration$OutputLocation. If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` Amazon Web Services account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
         *
         * If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See WorkGroupConfiguration$EnforceWorkGroupConfiguration and [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * The location in Amazon S3 where your query and calculation results are stored, such as `s3://path/to/query/bucket/`. For more information, see [Working with query results, recent queries, and output files](https://docs.aws.amazon.com/athena/latest/ug/querying.html). If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in `EnforceWorkGroupConfiguration` (true/false) in the `WorkGroupConfiguration`. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
         */
        public var outputLocation: kotlin.String? = null
        /**
         * If set to `true`, indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null. If set to `false` or not set, and a value is present in the `AclConfiguration` of `ResultConfigurationUpdates`, the `AclConfiguration` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
         */
        public var removeAclConfiguration: kotlin.Boolean? = null
        /**
         * If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the `EncryptionConfiguration` in `ResultConfigurationUpdates` (the client-side setting), the `EncryptionConfiguration` in the workgroup's `ResultConfiguration` will be updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
         */
        public var removeEncryptionConfiguration: kotlin.Boolean? = null
        /**
         * If set to "true", removes the Amazon Web Services account ID previously specified for ResultConfiguration$ExpectedBucketOwner. If set to "false" or not set, and a value is present in the `ExpectedBucketOwner` in `ResultConfigurationUpdates` (the client-side setting), the `ExpectedBucketOwner` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
         */
        public var removeExpectedBucketOwner: kotlin.Boolean? = null
        /**
         * If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the `OutputLocation` in `ResultConfigurationUpdates` (the client-side setting), the `OutputLocation` in the workgroup's `ResultConfiguration` will be updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
         */
        public var removeOutputLocation: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates) : this() {
            this.aclConfiguration = x.aclConfiguration
            this.encryptionConfiguration = x.encryptionConfiguration
            this.expectedBucketOwner = x.expectedBucketOwner
            this.outputLocation = x.outputLocation
            this.removeAclConfiguration = x.removeAclConfiguration
            this.removeEncryptionConfiguration = x.removeEncryptionConfiguration
            this.removeExpectedBucketOwner = x.removeExpectedBucketOwner
            this.removeOutputLocation = x.removeOutputLocation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates = ResultConfigurationUpdates(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.AclConfiguration] inside the given [block]
         */
        public fun aclConfiguration(block: aws.sdk.kotlin.services.athena.model.AclConfiguration.Builder.() -> kotlin.Unit) {
            this.aclConfiguration = aws.sdk.kotlin.services.athena.model.AclConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.athena.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.athena.model.EncryptionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
