// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Information about a single instance of a query execution.
 */
public class QueryExecution private constructor(builder: Builder) {
    /**
     * The engine version that executed the query.
     */
    public val engineVersion: aws.sdk.kotlin.services.athena.model.EngineVersion? = builder.engineVersion
    /**
     * A list of values for the parameters in a query. The values are applied sequentially to the parameters in the query in the order in which the parameters occur. The list of parameters is not returned in the response.
     */
    public val executionParameters: List<String>? = builder.executionParameters
    /**
     * The SQL query statements which the query execution ran.
     */
    public val query: kotlin.String? = builder.query
    /**
     * The database in which the query execution occurred.
     */
    public val queryExecutionContext: aws.sdk.kotlin.services.athena.model.QueryExecutionContext? = builder.queryExecutionContext
    /**
     * The unique identifier for each query execution.
     */
    public val queryExecutionId: kotlin.String? = builder.queryExecutionId
    /**
     * The location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used for query results. These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup.
     */
    public val resultConfiguration: aws.sdk.kotlin.services.athena.model.ResultConfiguration? = builder.resultConfiguration
    /**
     * Specifies the query result reuse behavior that was used for the query.
     */
    public val resultReuseConfiguration: aws.sdk.kotlin.services.athena.model.ResultReuseConfiguration? = builder.resultReuseConfiguration
    /**
     * The type of query statement that was run. `DDL` indicates DDL query statements. `DML` indicates DML (Data Manipulation Language) query statements, such as `CREATE TABLE AS SELECT`. `UTILITY` indicates query statements other than DDL and DML, such as `SHOW CREATE TABLE`, or `DESCRIBE TABLE`.
     */
    public val statementType: aws.sdk.kotlin.services.athena.model.StatementType? = builder.statementType
    /**
     * Query execution statistics, such as the amount of data scanned, the amount of time that the query took to process, and the type of statement that was run.
     */
    public val statistics: aws.sdk.kotlin.services.athena.model.QueryExecutionStatistics? = builder.statistics
    /**
     * The completion date, current state, submission time, and state change reason (if applicable) for the query execution.
     */
    public val status: aws.sdk.kotlin.services.athena.model.QueryExecutionStatus? = builder.status
    /**
     * The kind of query statement that was run.
     */
    public val substatementType: kotlin.String? = builder.substatementType
    /**
     * The name of the workgroup in which the query ran.
     */
    public val workGroup: kotlin.String? = builder.workGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.QueryExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryExecution(")
        append("engineVersion=$engineVersion,")
        append("executionParameters=$executionParameters,")
        append("query=$query,")
        append("queryExecutionContext=$queryExecutionContext,")
        append("queryExecutionId=$queryExecutionId,")
        append("resultConfiguration=$resultConfiguration,")
        append("resultReuseConfiguration=$resultReuseConfiguration,")
        append("statementType=$statementType,")
        append("statistics=$statistics,")
        append("status=$status,")
        append("substatementType=$substatementType,")
        append("workGroup=$workGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = engineVersion?.hashCode() ?: 0
        result = 31 * result + (executionParameters?.hashCode() ?: 0)
        result = 31 * result + (query?.hashCode() ?: 0)
        result = 31 * result + (queryExecutionContext?.hashCode() ?: 0)
        result = 31 * result + (queryExecutionId?.hashCode() ?: 0)
        result = 31 * result + (resultConfiguration?.hashCode() ?: 0)
        result = 31 * result + (resultReuseConfiguration?.hashCode() ?: 0)
        result = 31 * result + (statementType?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (substatementType?.hashCode() ?: 0)
        result = 31 * result + (workGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryExecution

        if (engineVersion != other.engineVersion) return false
        if (executionParameters != other.executionParameters) return false
        if (query != other.query) return false
        if (queryExecutionContext != other.queryExecutionContext) return false
        if (queryExecutionId != other.queryExecutionId) return false
        if (resultConfiguration != other.resultConfiguration) return false
        if (resultReuseConfiguration != other.resultReuseConfiguration) return false
        if (statementType != other.statementType) return false
        if (statistics != other.statistics) return false
        if (status != other.status) return false
        if (substatementType != other.substatementType) return false
        if (workGroup != other.workGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.QueryExecution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The engine version that executed the query.
         */
        public var engineVersion: aws.sdk.kotlin.services.athena.model.EngineVersion? = null
        /**
         * A list of values for the parameters in a query. The values are applied sequentially to the parameters in the query in the order in which the parameters occur. The list of parameters is not returned in the response.
         */
        public var executionParameters: List<String>? = null
        /**
         * The SQL query statements which the query execution ran.
         */
        public var query: kotlin.String? = null
        /**
         * The database in which the query execution occurred.
         */
        public var queryExecutionContext: aws.sdk.kotlin.services.athena.model.QueryExecutionContext? = null
        /**
         * The unique identifier for each query execution.
         */
        public var queryExecutionId: kotlin.String? = null
        /**
         * The location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used for query results. These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup.
         */
        public var resultConfiguration: aws.sdk.kotlin.services.athena.model.ResultConfiguration? = null
        /**
         * Specifies the query result reuse behavior that was used for the query.
         */
        public var resultReuseConfiguration: aws.sdk.kotlin.services.athena.model.ResultReuseConfiguration? = null
        /**
         * The type of query statement that was run. `DDL` indicates DDL query statements. `DML` indicates DML (Data Manipulation Language) query statements, such as `CREATE TABLE AS SELECT`. `UTILITY` indicates query statements other than DDL and DML, such as `SHOW CREATE TABLE`, or `DESCRIBE TABLE`.
         */
        public var statementType: aws.sdk.kotlin.services.athena.model.StatementType? = null
        /**
         * Query execution statistics, such as the amount of data scanned, the amount of time that the query took to process, and the type of statement that was run.
         */
        public var statistics: aws.sdk.kotlin.services.athena.model.QueryExecutionStatistics? = null
        /**
         * The completion date, current state, submission time, and state change reason (if applicable) for the query execution.
         */
        public var status: aws.sdk.kotlin.services.athena.model.QueryExecutionStatus? = null
        /**
         * The kind of query statement that was run.
         */
        public var substatementType: kotlin.String? = null
        /**
         * The name of the workgroup in which the query ran.
         */
        public var workGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.QueryExecution) : this() {
            this.engineVersion = x.engineVersion
            this.executionParameters = x.executionParameters
            this.query = x.query
            this.queryExecutionContext = x.queryExecutionContext
            this.queryExecutionId = x.queryExecutionId
            this.resultConfiguration = x.resultConfiguration
            this.resultReuseConfiguration = x.resultReuseConfiguration
            this.statementType = x.statementType
            this.statistics = x.statistics
            this.status = x.status
            this.substatementType = x.substatementType
            this.workGroup = x.workGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.QueryExecution = QueryExecution(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.EngineVersion] inside the given [block]
         */
        public fun engineVersion(block: aws.sdk.kotlin.services.athena.model.EngineVersion.Builder.() -> kotlin.Unit) {
            this.engineVersion = aws.sdk.kotlin.services.athena.model.EngineVersion.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.QueryExecutionContext] inside the given [block]
         */
        public fun queryExecutionContext(block: aws.sdk.kotlin.services.athena.model.QueryExecutionContext.Builder.() -> kotlin.Unit) {
            this.queryExecutionContext = aws.sdk.kotlin.services.athena.model.QueryExecutionContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.ResultConfiguration] inside the given [block]
         */
        public fun resultConfiguration(block: aws.sdk.kotlin.services.athena.model.ResultConfiguration.Builder.() -> kotlin.Unit) {
            this.resultConfiguration = aws.sdk.kotlin.services.athena.model.ResultConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.ResultReuseConfiguration] inside the given [block]
         */
        public fun resultReuseConfiguration(block: aws.sdk.kotlin.services.athena.model.ResultReuseConfiguration.Builder.() -> kotlin.Unit) {
            this.resultReuseConfiguration = aws.sdk.kotlin.services.athena.model.ResultReuseConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.QueryExecutionStatistics] inside the given [block]
         */
        public fun statistics(block: aws.sdk.kotlin.services.athena.model.QueryExecutionStatistics.Builder.() -> kotlin.Unit) {
            this.statistics = aws.sdk.kotlin.services.athena.model.QueryExecutionStatistics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.QueryExecutionStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.athena.model.QueryExecutionStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.athena.model.QueryExecutionStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
