// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * A query, where `QueryString` contains the SQL statements that make up the query.
 */
public class NamedQuery private constructor(builder: Builder) {
    /**
     * The database to which the query belongs.
     */
    public val database: kotlin.String = requireNotNull(builder.database) { "A non-null value must be provided for database" }
    /**
     * The query description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The query name.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The unique identifier of the query.
     */
    public val namedQueryId: kotlin.String? = builder.namedQueryId
    /**
     * The SQL statements that make up the query.
     */
    public val queryString: kotlin.String = requireNotNull(builder.queryString) { "A non-null value must be provided for queryString" }
    /**
     * The name of the workgroup that contains the named query.
     */
    public val workGroup: kotlin.String? = builder.workGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.NamedQuery = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NamedQuery(")
        append("database=$database,")
        append("description=$description,")
        append("name=$name,")
        append("namedQueryId=$namedQueryId,")
        append("queryString=$queryString,")
        append("workGroup=$workGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = database.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (namedQueryId?.hashCode() ?: 0)
        result = 31 * result + (queryString.hashCode())
        result = 31 * result + (workGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NamedQuery

        if (database != other.database) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (namedQueryId != other.namedQueryId) return false
        if (queryString != other.queryString) return false
        if (workGroup != other.workGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.NamedQuery = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The database to which the query belongs.
         */
        public var database: kotlin.String? = null
        /**
         * The query description.
         */
        public var description: kotlin.String? = null
        /**
         * The query name.
         */
        public var name: kotlin.String? = null
        /**
         * The unique identifier of the query.
         */
        public var namedQueryId: kotlin.String? = null
        /**
         * The SQL statements that make up the query.
         */
        public var queryString: kotlin.String? = null
        /**
         * The name of the workgroup that contains the named query.
         */
        public var workGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.NamedQuery) : this() {
            this.database = x.database
            this.description = x.description
            this.name = x.name
            this.namedQueryId = x.namedQueryId
            this.queryString = x.queryString
            this.workGroup = x.workGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.NamedQuery = NamedQuery(this)

        internal fun correctErrors(): Builder {
            if (database == null) database = ""
            if (name == null) name = ""
            if (queryString == null) queryString = ""
            return this
        }
    }
}
