// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



public class ListSessionsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of sessions to return.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the `NextToken` from the response object of the previous page call.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * A filter for a specific session state. A description of each state follows.
     *
     * `CREATING` - The session is being started, including acquiring resources.
     *
     * `CREATED` - The session has been started.
     *
     * `IDLE` - The session is able to accept a calculation.
     *
     * `BUSY` - The session is processing another task and is unable to accept a calculation.
     *
     * `TERMINATING` - The session is in the process of shutting down.
     *
     * `TERMINATED` - The session and its resources are no longer running.
     *
     * `DEGRADED` - The session has no healthy coordinators.
     *
     * `FAILED` - Due to a failure, the session and its resources are no longer running.
     */
    public val stateFilter: aws.sdk.kotlin.services.athena.model.SessionState? = builder.stateFilter
    /**
     * The workgroup to which the session belongs.
     */
    public val workGroup: kotlin.String? = builder.workGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.ListSessionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSessionsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("stateFilter=$stateFilter,")
        append("workGroup=$workGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (stateFilter?.hashCode() ?: 0)
        result = 31 * result + (workGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSessionsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (stateFilter != other.stateFilter) return false
        if (workGroup != other.workGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.ListSessionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of sessions to return.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the `NextToken` from the response object of the previous page call.
         */
        public var nextToken: kotlin.String? = null
        /**
         * A filter for a specific session state. A description of each state follows.
         *
         * `CREATING` - The session is being started, including acquiring resources.
         *
         * `CREATED` - The session has been started.
         *
         * `IDLE` - The session is able to accept a calculation.
         *
         * `BUSY` - The session is processing another task and is unable to accept a calculation.
         *
         * `TERMINATING` - The session is in the process of shutting down.
         *
         * `TERMINATED` - The session and its resources are no longer running.
         *
         * `DEGRADED` - The session has no healthy coordinators.
         *
         * `FAILED` - Due to a failure, the session and its resources are no longer running.
         */
        public var stateFilter: aws.sdk.kotlin.services.athena.model.SessionState? = null
        /**
         * The workgroup to which the session belongs.
         */
        public var workGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.ListSessionsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.stateFilter = x.stateFilter
            this.workGroup = x.workGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.ListSessionsRequest = ListSessionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
