// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



public class ListCalculationExecutionsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of calculation executions to return.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the `NextToken` from the response object of the previous page call.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The session ID.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * A filter for a specific calculation execution state. A description of each state follows.
     *
     * `CREATING` - The calculation is in the process of being created.
     *
     * `CREATED` - The calculation has been created and is ready to run.
     *
     * `QUEUED` - The calculation has been queued for processing.
     *
     * `RUNNING` - The calculation is running.
     *
     * `CANCELING` - A request to cancel the calculation has been received and the system is working to stop it.
     *
     * `CANCELED` - The calculation is no longer running as the result of a cancel request.
     *
     * `COMPLETED` - The calculation has completed without error.
     *
     * `FAILED` - The calculation failed and is no longer running.
     */
    public val stateFilter: aws.sdk.kotlin.services.athena.model.CalculationExecutionState? = builder.stateFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.ListCalculationExecutionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListCalculationExecutionsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sessionId=$sessionId,")
        append("stateFilter=$stateFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (stateFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListCalculationExecutionsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sessionId != other.sessionId) return false
        if (stateFilter != other.stateFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.ListCalculationExecutionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of calculation executions to return.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the `NextToken` from the response object of the previous page call.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The session ID.
         */
        public var sessionId: kotlin.String? = null
        /**
         * A filter for a specific calculation execution state. A description of each state follows.
         *
         * `CREATING` - The calculation is in the process of being created.
         *
         * `CREATED` - The calculation has been created and is ready to run.
         *
         * `QUEUED` - The calculation has been queued for processing.
         *
         * `RUNNING` - The calculation is running.
         *
         * `CANCELING` - A request to cancel the calculation has been received and the system is working to stop it.
         *
         * `CANCELED` - The calculation is no longer running as the result of a cancel request.
         *
         * `COMPLETED` - The calculation has completed without error.
         *
         * `FAILED` - The calculation failed and is no longer running.
         */
        public var stateFilter: aws.sdk.kotlin.services.athena.model.CalculationExecutionState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.ListCalculationExecutionsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sessionId = x.sessionId
            this.stateFilter = x.stateFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.ListCalculationExecutionsRequest = ListCalculationExecutionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
