// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



public class ImportNotebookRequest private constructor(builder: Builder) {
    /**
     * A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes only once).
     *
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of the notebook to import.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The notebook content to be imported.
     */
    public val payload: kotlin.String? = builder.payload
    /**
     * The notebook content type. Currently, the only valid type is `IPYNB`.
     */
    public val type: aws.sdk.kotlin.services.athena.model.NotebookType? = builder.type
    /**
     * The name of the Spark enabled workgroup to import the notebook to.
     */
    public val workGroup: kotlin.String? = builder.workGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.ImportNotebookRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportNotebookRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("name=$name,")
        append("payload=$payload,")
        append("type=$type,")
        append("workGroup=$workGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (payload?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (workGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportNotebookRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (name != other.name) return false
        if (payload != other.payload) return false
        if (type != other.type) return false
        if (workGroup != other.workGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.ImportNotebookRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes only once).
         *
         * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of the notebook to import.
         */
        public var name: kotlin.String? = null
        /**
         * The notebook content to be imported.
         */
        public var payload: kotlin.String? = null
        /**
         * The notebook content type. Currently, the only valid type is `IPYNB`.
         */
        public var type: aws.sdk.kotlin.services.athena.model.NotebookType? = null
        /**
         * The name of the Spark enabled workgroup to import the notebook to.
         */
        public var workGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.ImportNotebookRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.name = x.name
            this.payload = x.payload
            this.type = x.type
            this.workGroup = x.workGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.ImportNotebookRequest = ImportNotebookRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
