// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Contains summary information about an executor.
 */
public class ExecutorsSummary private constructor(builder: Builder) {
    /**
     * The UUID of the executor.
     */
    public val executorId: kotlin.String = requireNotNull(builder.executorId) { "A non-null value must be provided for executorId" }
    /**
     * The smallest unit of compute that a session can request from Athena. Size is measured in data processing unit (DPU) values, a relative measure of processing power.
     */
    public val executorSize: kotlin.Long? = builder.executorSize
    /**
     * The processing state of the executor. A description of each state follows.
     *
     * `CREATING` - The executor is being started, including acquiring resources.
     *
     * `CREATED` - The executor has been started.
     *
     * `REGISTERED` - The executor has been registered.
     *
     * `TERMINATING` - The executor is in the process of shutting down.
     *
     * `TERMINATED` - The executor is no longer running.
     *
     * `FAILED` - Due to a failure, the executor is no longer running.
     */
    public val executorState: aws.sdk.kotlin.services.athena.model.ExecutorState? = builder.executorState
    /**
     * The type of executor used for the application (`COORDINATOR`, `GATEWAY`, or `WORKER`).
     */
    public val executorType: aws.sdk.kotlin.services.athena.model.ExecutorType? = builder.executorType
    /**
     * The date and time that the executor started.
     */
    public val startDateTime: kotlin.Long? = builder.startDateTime
    /**
     * The date and time that the executor was terminated.
     */
    public val terminationDateTime: kotlin.Long? = builder.terminationDateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.ExecutorsSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecutorsSummary(")
        append("executorId=$executorId,")
        append("executorSize=$executorSize,")
        append("executorState=$executorState,")
        append("executorType=$executorType,")
        append("startDateTime=$startDateTime,")
        append("terminationDateTime=$terminationDateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = executorId.hashCode()
        result = 31 * result + (executorSize?.hashCode() ?: 0)
        result = 31 * result + (executorState?.hashCode() ?: 0)
        result = 31 * result + (executorType?.hashCode() ?: 0)
        result = 31 * result + (startDateTime?.hashCode() ?: 0)
        result = 31 * result + (terminationDateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecutorsSummary

        if (executorId != other.executorId) return false
        if (executorSize != other.executorSize) return false
        if (executorState != other.executorState) return false
        if (executorType != other.executorType) return false
        if (startDateTime != other.startDateTime) return false
        if (terminationDateTime != other.terminationDateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.ExecutorsSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The UUID of the executor.
         */
        public var executorId: kotlin.String? = null
        /**
         * The smallest unit of compute that a session can request from Athena. Size is measured in data processing unit (DPU) values, a relative measure of processing power.
         */
        public var executorSize: kotlin.Long? = null
        /**
         * The processing state of the executor. A description of each state follows.
         *
         * `CREATING` - The executor is being started, including acquiring resources.
         *
         * `CREATED` - The executor has been started.
         *
         * `REGISTERED` - The executor has been registered.
         *
         * `TERMINATING` - The executor is in the process of shutting down.
         *
         * `TERMINATED` - The executor is no longer running.
         *
         * `FAILED` - Due to a failure, the executor is no longer running.
         */
        public var executorState: aws.sdk.kotlin.services.athena.model.ExecutorState? = null
        /**
         * The type of executor used for the application (`COORDINATOR`, `GATEWAY`, or `WORKER`).
         */
        public var executorType: aws.sdk.kotlin.services.athena.model.ExecutorType? = null
        /**
         * The date and time that the executor started.
         */
        public var startDateTime: kotlin.Long? = null
        /**
         * The date and time that the executor was terminated.
         */
        public var terminationDateTime: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.ExecutorsSummary) : this() {
            this.executorId = x.executorId
            this.executorSize = x.executorSize
            this.executorState = x.executorState
            this.executorType = x.executorType
            this.startDateTime = x.startDateTime
            this.terminationDateTime = x.terminationDateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.ExecutorsSummary = ExecutorsSummary(this)

        internal fun correctErrors(): Builder {
            if (executorId == null) executorId = ""
            return this
        }
    }
}
