// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Contains information about an application-specific calculation result.
 */
public class CalculationResult private constructor(builder: Builder) {
    /**
     * The Amazon S3 location of the folder for the calculation results.
     */
    public val resultS3Uri: kotlin.String? = builder.resultS3Uri
    /**
     * The data format of the calculation result.
     */
    public val resultType: kotlin.String? = builder.resultType
    /**
     * The Amazon S3 location of the `stderr` error messages file for the calculation.
     */
    public val stdErrorS3Uri: kotlin.String? = builder.stdErrorS3Uri
    /**
     * The Amazon S3 location of the `stdout` file for the calculation.
     */
    public val stdOutS3Uri: kotlin.String? = builder.stdOutS3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.CalculationResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CalculationResult(")
        append("resultS3Uri=$resultS3Uri,")
        append("resultType=$resultType,")
        append("stdErrorS3Uri=$stdErrorS3Uri,")
        append("stdOutS3Uri=$stdOutS3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resultS3Uri?.hashCode() ?: 0
        result = 31 * result + (resultType?.hashCode() ?: 0)
        result = 31 * result + (stdErrorS3Uri?.hashCode() ?: 0)
        result = 31 * result + (stdOutS3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CalculationResult

        if (resultS3Uri != other.resultS3Uri) return false
        if (resultType != other.resultType) return false
        if (stdErrorS3Uri != other.stdErrorS3Uri) return false
        if (stdOutS3Uri != other.stdOutS3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.CalculationResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon S3 location of the folder for the calculation results.
         */
        public var resultS3Uri: kotlin.String? = null
        /**
         * The data format of the calculation result.
         */
        public var resultType: kotlin.String? = null
        /**
         * The Amazon S3 location of the `stderr` error messages file for the calculation.
         */
        public var stdErrorS3Uri: kotlin.String? = null
        /**
         * The Amazon S3 location of the `stdout` file for the calculation.
         */
        public var stdOutS3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.CalculationResult) : this() {
            this.resultS3Uri = x.resultS3Uri
            this.resultType = x.resultType
            this.stdErrorS3Uri = x.stdErrorS3Uri
            this.stdOutS3Uri = x.stdOutS3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.CalculationResult = CalculationResult(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
