// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.serde

import aws.sdk.kotlin.services.athena.model.EngineConfiguration
import aws.sdk.kotlin.services.athena.model.StartSessionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartSessionOperationSerializer: HttpSerialize<StartSessionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartSessionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeStartSessionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeStartSessionOperationBody(context: ExecutionContext, input: StartSessionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENGINECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EngineConfiguration"))
    val NOTEBOOKVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotebookVersion"))
    val SESSIONIDLETIMEOUTINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("SessionIdleTimeoutInMinutes"))
    val WORKGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENGINECONFIGURATION_DESCRIPTOR)
        field(NOTEBOOKVERSION_DESCRIPTOR)
        field(SESSIONIDLETIMEOUTINMINUTES_DESCRIPTOR)
        field(WORKGROUP_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.engineConfiguration?.let { field(ENGINECONFIGURATION_DESCRIPTOR, it, ::serializeEngineConfigurationDocument) }
        input.notebookVersion?.let { field(NOTEBOOKVERSION_DESCRIPTOR, it) }
        input.sessionIdleTimeoutInMinutes?.let { field(SESSIONIDLETIMEOUTINMINUTES_DESCRIPTOR, it) }
        input.workGroup?.let { field(WORKGROUP_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
