// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.serde

import aws.sdk.kotlin.services.athena.model.AthenaException
import aws.sdk.kotlin.services.athena.model.EngineConfiguration
import aws.sdk.kotlin.services.athena.model.GetSessionResponse
import aws.sdk.kotlin.services.athena.model.SessionConfiguration
import aws.sdk.kotlin.services.athena.model.SessionStatistics
import aws.sdk.kotlin.services.athena.model.SessionStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSessionOperationDeserializer: HttpDeserialize<GetSessionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetSessionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSessionError(context, call)
        }
        val builder = GetSessionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSessionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetSessionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AthenaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AthenaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSessionOperationBody(builder: GetSessionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENGINECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EngineConfiguration"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EngineVersion"))
    val NOTEBOOKVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotebookVersion"))
    val SESSIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SessionConfiguration"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SessionId"))
    val STATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Statistics"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Status"))
    val WORKGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(ENGINECONFIGURATION_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(NOTEBOOKVERSION_DESCRIPTOR)
        field(SESSIONCONFIGURATION_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
        field(STATISTICS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(WORKGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENGINECONFIGURATION_DESCRIPTOR.index -> builder.engineConfiguration = deserializeEngineConfigurationDocument(deserializer)
                ENGINEVERSION_DESCRIPTOR.index -> builder.engineVersion = deserializeString()
                NOTEBOOKVERSION_DESCRIPTOR.index -> builder.notebookVersion = deserializeString()
                SESSIONCONFIGURATION_DESCRIPTOR.index -> builder.sessionConfiguration = deserializeSessionConfigurationDocument(deserializer)
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                STATISTICS_DESCRIPTOR.index -> builder.statistics = deserializeSessionStatisticsDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeSessionStatusDocument(deserializer)
                WORKGROUP_DESCRIPTOR.index -> builder.workGroup = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
