// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.serde

import aws.sdk.kotlin.services.athena.model.AthenaException
import aws.sdk.kotlin.services.athena.model.CalculationResult
import aws.sdk.kotlin.services.athena.model.CalculationStatistics
import aws.sdk.kotlin.services.athena.model.CalculationStatus
import aws.sdk.kotlin.services.athena.model.GetCalculationExecutionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCalculationExecutionOperationDeserializer: HttpDeserialize<GetCalculationExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetCalculationExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetCalculationExecutionError(context, call)
        }
        val builder = GetCalculationExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCalculationExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetCalculationExecutionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AthenaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AthenaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCalculationExecutionOperationBody(builder: GetCalculationExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CALCULATIONEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CalculationExecutionId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val RESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Result"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SessionId"))
    val STATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Statistics"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Status"))
    val WORKINGDIRECTORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkingDirectory"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CALCULATIONEXECUTIONID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(RESULT_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
        field(STATISTICS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(WORKINGDIRECTORY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CALCULATIONEXECUTIONID_DESCRIPTOR.index -> builder.calculationExecutionId = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                RESULT_DESCRIPTOR.index -> builder.result = deserializeCalculationResultDocument(deserializer)
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                STATISTICS_DESCRIPTOR.index -> builder.statistics = deserializeCalculationStatisticsDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeCalculationStatusDocument(deserializer)
                WORKINGDIRECTORY_DESCRIPTOR.index -> builder.workingDirectory = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
