// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query and calculation results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
 */
public class WorkGroupConfigurationUpdates private constructor(builder: Builder) {
    /**
     * Contains a user defined string in JSON format for a Spark-enabled workgroup.
     */
    public val additionalConfiguration: kotlin.String? = builder.additionalConfiguration
    /**
     * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     */
    public val bytesScannedCutoffPerQuery: kotlin.Long? = builder.bytesScannedCutoffPerQuery
    /**
     * Specifies the customer managed KMS key that is used to encrypt the user's data stores in Athena. When an Amazon Web Services managed key is used, this value is null. This setting does not apply to Athena SQL workgroups.
     */
    public val customerContentEncryptionConfiguration: aws.sdk.kotlin.services.athena.model.CustomerContentEncryptionConfiguration? = builder.customerContentEncryptionConfiguration
    /**
     * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or higher when they submit queries. This setting does not apply to Spark-enabled workgroups.
     *
     * The `EnforceWorkGroupConfiguration` setting takes precedence over the `EnableMinimumEncryptionConfiguration` flag. This means that if `EnforceWorkGroupConfiguration` is true, the `EnableMinimumEncryptionConfiguration` flag is ignored, and the workgroup configuration for encryption is used.
     */
    public val enableMinimumEncryptionConfiguration: kotlin.Boolean? = builder.enableMinimumEncryptionConfiguration
    /**
     * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side settings are used. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
     */
    public val enforceWorkGroupConfiguration: kotlin.Boolean? = builder.enforceWorkGroupConfiguration
    /**
     * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on the requested engine version. If no value was previously set, the default is Auto. Queries on the `AmazonAthenaPreviewFunctionality` workgroup run on the preview engine regardless of this setting.
     */
    public val engineVersion: aws.sdk.kotlin.services.athena.model.EngineVersion? = builder.engineVersion
    /**
     * The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     */
    public val publishCloudWatchMetricsEnabled: kotlin.Boolean? = builder.publishCloudWatchMetricsEnabled
    /**
     * Specifies whether Amazon S3 access grants are enabled for query results.
     */
    public val queryResultsS3AccessGrantsConfiguration: aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration? = builder.queryResultsS3AccessGrantsConfiguration
    /**
     * Indicates that the data usage control limit per query is removed. WorkGroupConfiguration$BytesScannedCutoffPerQuery
     */
    public val removeBytesScannedCutoffPerQuery: kotlin.Boolean? = builder.removeBytesScannedCutoffPerQuery
    /**
     * Removes content encryption configuration from an Apache Spark-enabled Athena workgroup.
     */
    public val removeCustomerContentEncryptionConfiguration: kotlin.Boolean? = builder.removeCustomerContentEncryptionConfiguration
    /**
     * If set to `true`, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets in queries. If set to `false`, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false`. For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide*.
     */
    public val requesterPaysEnabled: kotlin.Boolean? = builder.requesterPaysEnabled
    /**
     * The result configuration information about the queries in this workgroup that will be updated. Includes the updated results location and an updated option for encrypting query results.
     */
    public val resultConfigurationUpdates: aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates? = builder.resultConfigurationUpdates

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.WorkGroupConfigurationUpdates = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkGroupConfigurationUpdates(")
        append("additionalConfiguration=$additionalConfiguration,")
        append("bytesScannedCutoffPerQuery=$bytesScannedCutoffPerQuery,")
        append("customerContentEncryptionConfiguration=$customerContentEncryptionConfiguration,")
        append("enableMinimumEncryptionConfiguration=$enableMinimumEncryptionConfiguration,")
        append("enforceWorkGroupConfiguration=$enforceWorkGroupConfiguration,")
        append("engineVersion=$engineVersion,")
        append("executionRole=$executionRole,")
        append("publishCloudWatchMetricsEnabled=$publishCloudWatchMetricsEnabled,")
        append("queryResultsS3AccessGrantsConfiguration=$queryResultsS3AccessGrantsConfiguration,")
        append("removeBytesScannedCutoffPerQuery=$removeBytesScannedCutoffPerQuery,")
        append("removeCustomerContentEncryptionConfiguration=$removeCustomerContentEncryptionConfiguration,")
        append("requesterPaysEnabled=$requesterPaysEnabled,")
        append("resultConfigurationUpdates=$resultConfigurationUpdates")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalConfiguration?.hashCode() ?: 0
        result = 31 * result + (bytesScannedCutoffPerQuery?.hashCode() ?: 0)
        result = 31 * result + (customerContentEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (enableMinimumEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (enforceWorkGroupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (publishCloudWatchMetricsEnabled?.hashCode() ?: 0)
        result = 31 * result + (queryResultsS3AccessGrantsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (removeBytesScannedCutoffPerQuery?.hashCode() ?: 0)
        result = 31 * result + (removeCustomerContentEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (requesterPaysEnabled?.hashCode() ?: 0)
        result = 31 * result + (resultConfigurationUpdates?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkGroupConfigurationUpdates

        if (additionalConfiguration != other.additionalConfiguration) return false
        if (bytesScannedCutoffPerQuery != other.bytesScannedCutoffPerQuery) return false
        if (customerContentEncryptionConfiguration != other.customerContentEncryptionConfiguration) return false
        if (enableMinimumEncryptionConfiguration != other.enableMinimumEncryptionConfiguration) return false
        if (enforceWorkGroupConfiguration != other.enforceWorkGroupConfiguration) return false
        if (engineVersion != other.engineVersion) return false
        if (executionRole != other.executionRole) return false
        if (publishCloudWatchMetricsEnabled != other.publishCloudWatchMetricsEnabled) return false
        if (queryResultsS3AccessGrantsConfiguration != other.queryResultsS3AccessGrantsConfiguration) return false
        if (removeBytesScannedCutoffPerQuery != other.removeBytesScannedCutoffPerQuery) return false
        if (removeCustomerContentEncryptionConfiguration != other.removeCustomerContentEncryptionConfiguration) return false
        if (requesterPaysEnabled != other.requesterPaysEnabled) return false
        if (resultConfigurationUpdates != other.resultConfigurationUpdates) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.WorkGroupConfigurationUpdates = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains a user defined string in JSON format for a Spark-enabled workgroup.
         */
        public var additionalConfiguration: kotlin.String? = null
        /**
         * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         */
        public var bytesScannedCutoffPerQuery: kotlin.Long? = null
        /**
         * Specifies the customer managed KMS key that is used to encrypt the user's data stores in Athena. When an Amazon Web Services managed key is used, this value is null. This setting does not apply to Athena SQL workgroups.
         */
        public var customerContentEncryptionConfiguration: aws.sdk.kotlin.services.athena.model.CustomerContentEncryptionConfiguration? = null
        /**
         * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or higher when they submit queries. This setting does not apply to Spark-enabled workgroups.
         *
         * The `EnforceWorkGroupConfiguration` setting takes precedence over the `EnableMinimumEncryptionConfiguration` flag. This means that if `EnforceWorkGroupConfiguration` is true, the `EnableMinimumEncryptionConfiguration` flag is ignored, and the workgroup configuration for encryption is used.
         */
        public var enableMinimumEncryptionConfiguration: kotlin.Boolean? = null
        /**
         * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side settings are used. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
         */
        public var enforceWorkGroupConfiguration: kotlin.Boolean? = null
        /**
         * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on the requested engine version. If no value was previously set, the default is Auto. Queries on the `AmazonAthenaPreviewFunctionality` workgroup run on the preview engine regardless of this setting.
         */
        public var engineVersion: aws.sdk.kotlin.services.athena.model.EngineVersion? = null
        /**
         * The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.
         */
        public var executionRole: kotlin.String? = null
        /**
         * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
         */
        public var publishCloudWatchMetricsEnabled: kotlin.Boolean? = null
        /**
         * Specifies whether Amazon S3 access grants are enabled for query results.
         */
        public var queryResultsS3AccessGrantsConfiguration: aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration? = null
        /**
         * Indicates that the data usage control limit per query is removed. WorkGroupConfiguration$BytesScannedCutoffPerQuery
         */
        public var removeBytesScannedCutoffPerQuery: kotlin.Boolean? = null
        /**
         * Removes content encryption configuration from an Apache Spark-enabled Athena workgroup.
         */
        public var removeCustomerContentEncryptionConfiguration: kotlin.Boolean? = null
        /**
         * If set to `true`, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets in queries. If set to `false`, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false`. For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide*.
         */
        public var requesterPaysEnabled: kotlin.Boolean? = null
        /**
         * The result configuration information about the queries in this workgroup that will be updated. Includes the updated results location and an updated option for encrypting query results.
         */
        public var resultConfigurationUpdates: aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.WorkGroupConfigurationUpdates) : this() {
            this.additionalConfiguration = x.additionalConfiguration
            this.bytesScannedCutoffPerQuery = x.bytesScannedCutoffPerQuery
            this.customerContentEncryptionConfiguration = x.customerContentEncryptionConfiguration
            this.enableMinimumEncryptionConfiguration = x.enableMinimumEncryptionConfiguration
            this.enforceWorkGroupConfiguration = x.enforceWorkGroupConfiguration
            this.engineVersion = x.engineVersion
            this.executionRole = x.executionRole
            this.publishCloudWatchMetricsEnabled = x.publishCloudWatchMetricsEnabled
            this.queryResultsS3AccessGrantsConfiguration = x.queryResultsS3AccessGrantsConfiguration
            this.removeBytesScannedCutoffPerQuery = x.removeBytesScannedCutoffPerQuery
            this.removeCustomerContentEncryptionConfiguration = x.removeCustomerContentEncryptionConfiguration
            this.requesterPaysEnabled = x.requesterPaysEnabled
            this.resultConfigurationUpdates = x.resultConfigurationUpdates
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.WorkGroupConfigurationUpdates = WorkGroupConfigurationUpdates(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.CustomerContentEncryptionConfiguration] inside the given [block]
         */
        public fun customerContentEncryptionConfiguration(block: aws.sdk.kotlin.services.athena.model.CustomerContentEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.customerContentEncryptionConfiguration = aws.sdk.kotlin.services.athena.model.CustomerContentEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.EngineVersion] inside the given [block]
         */
        public fun engineVersion(block: aws.sdk.kotlin.services.athena.model.EngineVersion.Builder.() -> kotlin.Unit) {
            this.engineVersion = aws.sdk.kotlin.services.athena.model.EngineVersion.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration] inside the given [block]
         */
        public fun queryResultsS3AccessGrantsConfiguration(block: aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration.Builder.() -> kotlin.Unit) {
            this.queryResultsS3AccessGrantsConfiguration = aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates] inside the given [block]
         */
        public fun resultConfigurationUpdates(block: aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates.Builder.() -> kotlin.Unit) {
            this.resultConfigurationUpdates = aws.sdk.kotlin.services.athena.model.ResultConfigurationUpdates.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
