// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * The configuration of the workgroup, which includes the location in Amazon S3 where query and calculation results are stored, the encryption option, if any, used for query and calculation results, whether the Amazon CloudWatch Metrics are enabled for the workgroup and whether workgroup settings override query settings, and the data usage limits for the amount of data scanned per query or per workgroup. The workgroup settings override is specified in `EnforceWorkGroupConfiguration` (true/false) in the `WorkGroupConfiguration`. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
 */
public class WorkGroupConfiguration private constructor(builder: Builder) {
    /**
     * Specifies a user defined JSON string that is passed to the notebook engine.
     */
    public val additionalConfiguration: kotlin.String? = builder.additionalConfiguration
    /**
     * The upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     */
    public val bytesScannedCutoffPerQuery: kotlin.Long? = builder.bytesScannedCutoffPerQuery
    /**
     * Specifies the KMS key that is used to encrypt the user's data stores in Athena. This setting does not apply to Athena SQL workgroups.
     */
    public val customerContentEncryptionConfiguration: aws.sdk.kotlin.services.athena.model.CustomerContentEncryptionConfiguration? = builder.customerContentEncryptionConfiguration
    /**
     * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or higher when they submit queries.
     *
     * The `EnforceWorkGroupConfiguration` setting takes precedence over the `EnableMinimumEncryptionConfiguration` flag. This means that if `EnforceWorkGroupConfiguration` is true, the `EnableMinimumEncryptionConfiguration` flag is ignored, and the workgroup configuration for encryption is used.
     */
    public val enableMinimumEncryptionConfiguration: kotlin.Boolean? = builder.enableMinimumEncryptionConfiguration
    /**
     * If set to "true", the settings for the workgroup override client-side settings. If set to "false", client-side settings are used. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
     */
    public val enforceWorkGroupConfiguration: kotlin.Boolean? = builder.enforceWorkGroupConfiguration
    /**
     * The engine version that all queries running on the workgroup use. Queries on the `AmazonAthenaPreviewFunctionality` workgroup run on the preview engine regardless of this setting.
     */
    public val engineVersion: aws.sdk.kotlin.services.athena.model.EngineVersion? = builder.engineVersion
    /**
     * The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * Specifies whether the workgroup is IAM Identity Center supported.
     */
    public val identityCenterConfiguration: aws.sdk.kotlin.services.athena.model.IdentityCenterConfiguration? = builder.identityCenterConfiguration
    /**
     * Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
     */
    public val publishCloudWatchMetricsEnabled: kotlin.Boolean? = builder.publishCloudWatchMetricsEnabled
    /**
     * Specifies whether Amazon S3 access grants are enabled for query results.
     */
    public val queryResultsS3AccessGrantsConfiguration: aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration? = builder.queryResultsS3AccessGrantsConfiguration
    /**
     * If set to `true`, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to `false`, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false`. For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide*.
     */
    public val requesterPaysEnabled: kotlin.Boolean? = builder.requesterPaysEnabled
    /**
     * The configuration for the workgroup, which includes the location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used for query and calculation results. To run the query, you must specify the query results location using one of the ways: either in the workgroup using this setting, or for individual queries (client-side), using ResultConfiguration$OutputLocation. If none of them is set, Athena issues an error that no output location is provided. For more information, see [Working with query results, recent queries, and output files](https://docs.aws.amazon.com/athena/latest/ug/querying.html).
     */
    public val resultConfiguration: aws.sdk.kotlin.services.athena.model.ResultConfiguration? = builder.resultConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.WorkGroupConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkGroupConfiguration(")
        append("additionalConfiguration=$additionalConfiguration,")
        append("bytesScannedCutoffPerQuery=$bytesScannedCutoffPerQuery,")
        append("customerContentEncryptionConfiguration=$customerContentEncryptionConfiguration,")
        append("enableMinimumEncryptionConfiguration=$enableMinimumEncryptionConfiguration,")
        append("enforceWorkGroupConfiguration=$enforceWorkGroupConfiguration,")
        append("engineVersion=$engineVersion,")
        append("executionRole=$executionRole,")
        append("identityCenterConfiguration=$identityCenterConfiguration,")
        append("publishCloudWatchMetricsEnabled=$publishCloudWatchMetricsEnabled,")
        append("queryResultsS3AccessGrantsConfiguration=$queryResultsS3AccessGrantsConfiguration,")
        append("requesterPaysEnabled=$requesterPaysEnabled,")
        append("resultConfiguration=$resultConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalConfiguration?.hashCode() ?: 0
        result = 31 * result + (bytesScannedCutoffPerQuery?.hashCode() ?: 0)
        result = 31 * result + (customerContentEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (enableMinimumEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (enforceWorkGroupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (identityCenterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (publishCloudWatchMetricsEnabled?.hashCode() ?: 0)
        result = 31 * result + (queryResultsS3AccessGrantsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (requesterPaysEnabled?.hashCode() ?: 0)
        result = 31 * result + (resultConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkGroupConfiguration

        if (additionalConfiguration != other.additionalConfiguration) return false
        if (bytesScannedCutoffPerQuery != other.bytesScannedCutoffPerQuery) return false
        if (customerContentEncryptionConfiguration != other.customerContentEncryptionConfiguration) return false
        if (enableMinimumEncryptionConfiguration != other.enableMinimumEncryptionConfiguration) return false
        if (enforceWorkGroupConfiguration != other.enforceWorkGroupConfiguration) return false
        if (engineVersion != other.engineVersion) return false
        if (executionRole != other.executionRole) return false
        if (identityCenterConfiguration != other.identityCenterConfiguration) return false
        if (publishCloudWatchMetricsEnabled != other.publishCloudWatchMetricsEnabled) return false
        if (queryResultsS3AccessGrantsConfiguration != other.queryResultsS3AccessGrantsConfiguration) return false
        if (requesterPaysEnabled != other.requesterPaysEnabled) return false
        if (resultConfiguration != other.resultConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.WorkGroupConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies a user defined JSON string that is passed to the notebook engine.
         */
        public var additionalConfiguration: kotlin.String? = null
        /**
         * The upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         */
        public var bytesScannedCutoffPerQuery: kotlin.Long? = null
        /**
         * Specifies the KMS key that is used to encrypt the user's data stores in Athena. This setting does not apply to Athena SQL workgroups.
         */
        public var customerContentEncryptionConfiguration: aws.sdk.kotlin.services.athena.model.CustomerContentEncryptionConfiguration? = null
        /**
         * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or higher when they submit queries.
         *
         * The `EnforceWorkGroupConfiguration` setting takes precedence over the `EnableMinimumEncryptionConfiguration` flag. This means that if `EnforceWorkGroupConfiguration` is true, the `EnableMinimumEncryptionConfiguration` flag is ignored, and the workgroup configuration for encryption is used.
         */
        public var enableMinimumEncryptionConfiguration: kotlin.Boolean? = null
        /**
         * If set to "true", the settings for the workgroup override client-side settings. If set to "false", client-side settings are used. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
         */
        public var enforceWorkGroupConfiguration: kotlin.Boolean? = null
        /**
         * The engine version that all queries running on the workgroup use. Queries on the `AmazonAthenaPreviewFunctionality` workgroup run on the preview engine regardless of this setting.
         */
        public var engineVersion: aws.sdk.kotlin.services.athena.model.EngineVersion? = null
        /**
         * The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.
         */
        public var executionRole: kotlin.String? = null
        /**
         * Specifies whether the workgroup is IAM Identity Center supported.
         */
        public var identityCenterConfiguration: aws.sdk.kotlin.services.athena.model.IdentityCenterConfiguration? = null
        /**
         * Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
         */
        public var publishCloudWatchMetricsEnabled: kotlin.Boolean? = null
        /**
         * Specifies whether Amazon S3 access grants are enabled for query results.
         */
        public var queryResultsS3AccessGrantsConfiguration: aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration? = null
        /**
         * If set to `true`, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to `false`, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false`. For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide*.
         */
        public var requesterPaysEnabled: kotlin.Boolean? = null
        /**
         * The configuration for the workgroup, which includes the location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used for query and calculation results. To run the query, you must specify the query results location using one of the ways: either in the workgroup using this setting, or for individual queries (client-side), using ResultConfiguration$OutputLocation. If none of them is set, Athena issues an error that no output location is provided. For more information, see [Working with query results, recent queries, and output files](https://docs.aws.amazon.com/athena/latest/ug/querying.html).
         */
        public var resultConfiguration: aws.sdk.kotlin.services.athena.model.ResultConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.WorkGroupConfiguration) : this() {
            this.additionalConfiguration = x.additionalConfiguration
            this.bytesScannedCutoffPerQuery = x.bytesScannedCutoffPerQuery
            this.customerContentEncryptionConfiguration = x.customerContentEncryptionConfiguration
            this.enableMinimumEncryptionConfiguration = x.enableMinimumEncryptionConfiguration
            this.enforceWorkGroupConfiguration = x.enforceWorkGroupConfiguration
            this.engineVersion = x.engineVersion
            this.executionRole = x.executionRole
            this.identityCenterConfiguration = x.identityCenterConfiguration
            this.publishCloudWatchMetricsEnabled = x.publishCloudWatchMetricsEnabled
            this.queryResultsS3AccessGrantsConfiguration = x.queryResultsS3AccessGrantsConfiguration
            this.requesterPaysEnabled = x.requesterPaysEnabled
            this.resultConfiguration = x.resultConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.WorkGroupConfiguration = WorkGroupConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.CustomerContentEncryptionConfiguration] inside the given [block]
         */
        public fun customerContentEncryptionConfiguration(block: aws.sdk.kotlin.services.athena.model.CustomerContentEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.customerContentEncryptionConfiguration = aws.sdk.kotlin.services.athena.model.CustomerContentEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.EngineVersion] inside the given [block]
         */
        public fun engineVersion(block: aws.sdk.kotlin.services.athena.model.EngineVersion.Builder.() -> kotlin.Unit) {
            this.engineVersion = aws.sdk.kotlin.services.athena.model.EngineVersion.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.IdentityCenterConfiguration] inside the given [block]
         */
        public fun identityCenterConfiguration(block: aws.sdk.kotlin.services.athena.model.IdentityCenterConfiguration.Builder.() -> kotlin.Unit) {
            this.identityCenterConfiguration = aws.sdk.kotlin.services.athena.model.IdentityCenterConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration] inside the given [block]
         */
        public fun queryResultsS3AccessGrantsConfiguration(block: aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration.Builder.() -> kotlin.Unit) {
            this.queryResultsS3AccessGrantsConfiguration = aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.ResultConfiguration] inside the given [block]
         */
        public fun resultConfiguration(block: aws.sdk.kotlin.services.athena.model.ResultConfiguration.Builder.() -> kotlin.Unit) {
            this.resultConfiguration = aws.sdk.kotlin.services.athena.model.ResultConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
