// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * The name of a prepared statement that could not be returned.
 */
public class UnprocessedPreparedStatementName private constructor(builder: Builder) {
    /**
     * The error code returned when the request for the prepared statement failed.
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * The error message containing the reason why the prepared statement could not be returned. The following error messages are possible:
     * + `INVALID_INPUT` - The name of the prepared statement that was provided is not valid (for example, the name is too long).
     * + `STATEMENT_NOT_FOUND` - A prepared statement with the name provided could not be found.
     * + `UNAUTHORIZED` - The requester does not have permission to access the workgroup that contains the prepared statement.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The name of a prepared statement that could not be returned due to an error.
     */
    public val statementName: kotlin.String? = builder.statementName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.UnprocessedPreparedStatementName = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UnprocessedPreparedStatementName(")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("statementName=$statementName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (statementName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UnprocessedPreparedStatementName

        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (statementName != other.statementName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.UnprocessedPreparedStatementName = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The error code returned when the request for the prepared statement failed.
         */
        public var errorCode: kotlin.String? = null
        /**
         * The error message containing the reason why the prepared statement could not be returned. The following error messages are possible:
         * + `INVALID_INPUT` - The name of the prepared statement that was provided is not valid (for example, the name is too long).
         * + `STATEMENT_NOT_FOUND` - A prepared statement with the name provided could not be found.
         * + `UNAUTHORIZED` - The requester does not have permission to access the workgroup that contains the prepared statement.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The name of a prepared statement that could not be returned due to an error.
         */
        public var statementName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.UnprocessedPreparedStatementName) : this() {
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.statementName = x.statementName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.UnprocessedPreparedStatementName = UnprocessedPreparedStatementName(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
