// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata for a table.
 */
public class TableMetadata private constructor(builder: Builder) {
    /**
     * A list of the columns in the table.
     */
    public val columns: List<Column>? = builder.columns
    /**
     * The time that the table was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The last time the table was accessed.
     */
    public val lastAccessTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAccessTime
    /**
     * The name of the table.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A set of custom key/value pairs for table properties.
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * A list of the partition keys in the table.
     */
    public val partitionKeys: List<Column>? = builder.partitionKeys
    /**
     * The type of table. In Athena, only `EXTERNAL_TABLE` is supported.
     */
    public val tableType: kotlin.String? = builder.tableType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.TableMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TableMetadata(")
        append("columns=$columns,")
        append("createTime=$createTime,")
        append("lastAccessTime=$lastAccessTime,")
        append("name=$name,")
        append("parameters=$parameters,")
        append("partitionKeys=$partitionKeys,")
        append("tableType=$tableType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = columns?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (lastAccessTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (partitionKeys?.hashCode() ?: 0)
        result = 31 * result + (tableType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TableMetadata

        if (columns != other.columns) return false
        if (createTime != other.createTime) return false
        if (lastAccessTime != other.lastAccessTime) return false
        if (name != other.name) return false
        if (parameters != other.parameters) return false
        if (partitionKeys != other.partitionKeys) return false
        if (tableType != other.tableType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.TableMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of the columns in the table.
         */
        public var columns: List<Column>? = null
        /**
         * The time that the table was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time the table was accessed.
         */
        public var lastAccessTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the table.
         */
        public var name: kotlin.String? = null
        /**
         * A set of custom key/value pairs for table properties.
         */
        public var parameters: Map<String, String>? = null
        /**
         * A list of the partition keys in the table.
         */
        public var partitionKeys: List<Column>? = null
        /**
         * The type of table. In Athena, only `EXTERNAL_TABLE` is supported.
         */
        public var tableType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.TableMetadata) : this() {
            this.columns = x.columns
            this.createTime = x.createTime
            this.lastAccessTime = x.lastAccessTime
            this.name = x.name
            this.parameters = x.parameters
            this.partitionKeys = x.partitionKeys
            this.tableType = x.tableType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.TableMetadata = TableMetadata(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
