// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



public class StartSessionRequest private constructor(builder: Builder) {
    /**
     * A unique case-sensitive string used to ensure the request to create the session is idempotent (executes only once). If another `StartSessionRequest` is received, the same response is returned and another session is not created. If a parameter has changed, an error is returned.
     *
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The session description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Contains engine data processing unit (DPU) configuration settings and parameter mappings.
     */
    public val engineConfiguration: aws.sdk.kotlin.services.athena.model.EngineConfiguration? = builder.engineConfiguration
    /**
     * The notebook version. This value is supplied automatically for notebook sessions in the Athena console and is not required for programmatic session access. The only valid notebook version is `Athena notebook version 1`. If you specify a value for `NotebookVersion`, you must also specify a value for `NotebookId`. See EngineConfiguration$AdditionalConfigs.
     */
    public val notebookVersion: kotlin.String? = builder.notebookVersion
    /**
     * The idle timeout in minutes for the session.
     */
    public val sessionIdleTimeoutInMinutes: kotlin.Int? = builder.sessionIdleTimeoutInMinutes
    /**
     * The workgroup to which the session belongs.
     */
    public val workGroup: kotlin.String? = builder.workGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.StartSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSessionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("engineConfiguration=$engineConfiguration,")
        append("notebookVersion=$notebookVersion,")
        append("sessionIdleTimeoutInMinutes=$sessionIdleTimeoutInMinutes,")
        append("workGroup=$workGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineConfiguration?.hashCode() ?: 0)
        result = 31 * result + (notebookVersion?.hashCode() ?: 0)
        result = 31 * result + (sessionIdleTimeoutInMinutes ?: 0)
        result = 31 * result + (workGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSessionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (engineConfiguration != other.engineConfiguration) return false
        if (notebookVersion != other.notebookVersion) return false
        if (sessionIdleTimeoutInMinutes != other.sessionIdleTimeoutInMinutes) return false
        if (workGroup != other.workGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.StartSessionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique case-sensitive string used to ensure the request to create the session is idempotent (executes only once). If another `StartSessionRequest` is received, the same response is returned and another session is not created. If a parameter has changed, an error is returned.
         *
         * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The session description.
         */
        public var description: kotlin.String? = null
        /**
         * Contains engine data processing unit (DPU) configuration settings and parameter mappings.
         */
        public var engineConfiguration: aws.sdk.kotlin.services.athena.model.EngineConfiguration? = null
        /**
         * The notebook version. This value is supplied automatically for notebook sessions in the Athena console and is not required for programmatic session access. The only valid notebook version is `Athena notebook version 1`. If you specify a value for `NotebookVersion`, you must also specify a value for `NotebookId`. See EngineConfiguration$AdditionalConfigs.
         */
        public var notebookVersion: kotlin.String? = null
        /**
         * The idle timeout in minutes for the session.
         */
        public var sessionIdleTimeoutInMinutes: kotlin.Int? = null
        /**
         * The workgroup to which the session belongs.
         */
        public var workGroup: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.StartSessionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.engineConfiguration = x.engineConfiguration
            this.notebookVersion = x.notebookVersion
            this.sessionIdleTimeoutInMinutes = x.sessionIdleTimeoutInMinutes
            this.workGroup = x.workGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.StartSessionRequest = StartSessionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.EngineConfiguration] inside the given [block]
         */
        public fun engineConfiguration(block: aws.sdk.kotlin.services.athena.model.EngineConfiguration.Builder.() -> kotlin.Unit) {
            this.engineConfiguration = aws.sdk.kotlin.services.athena.model.EngineConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
