// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the status of a session.
 */
public class SessionStatus private constructor(builder: Builder) {
    /**
     * The date and time that the session ended.
     */
    public val endDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endDateTime
    /**
     * The date and time starting at which the session became idle. Can be empty if the session is not currently idle.
     */
    public val idleSinceDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.idleSinceDateTime
    /**
     * The most recent date and time that the session was modified.
     */
    public val lastModifiedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDateTime
    /**
     * The date and time that the session started.
     */
    public val startDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startDateTime
    /**
     * The state of the session. A description of each state follows.
     *
     * `CREATING` - The session is being started, including acquiring resources.
     *
     * `CREATED` - The session has been started.
     *
     * `IDLE` - The session is able to accept a calculation.
     *
     * `BUSY` - The session is processing another task and is unable to accept a calculation.
     *
     * `TERMINATING` - The session is in the process of shutting down.
     *
     * `TERMINATED` - The session and its resources are no longer running.
     *
     * `DEGRADED` - The session has no healthy coordinators.
     *
     * `FAILED` - Due to a failure, the session and its resources are no longer running.
     */
    public val state: aws.sdk.kotlin.services.athena.model.SessionState? = builder.state
    /**
     * The reason for the session state change (for example, canceled because the session was terminated).
     */
    public val stateChangeReason: kotlin.String? = builder.stateChangeReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.SessionStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionStatus(")
        append("endDateTime=$endDateTime,")
        append("idleSinceDateTime=$idleSinceDateTime,")
        append("lastModifiedDateTime=$lastModifiedDateTime,")
        append("startDateTime=$startDateTime,")
        append("state=$state,")
        append("stateChangeReason=$stateChangeReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDateTime?.hashCode() ?: 0
        result = 31 * result + (idleSinceDateTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDateTime?.hashCode() ?: 0)
        result = 31 * result + (startDateTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateChangeReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionStatus

        if (endDateTime != other.endDateTime) return false
        if (idleSinceDateTime != other.idleSinceDateTime) return false
        if (lastModifiedDateTime != other.lastModifiedDateTime) return false
        if (startDateTime != other.startDateTime) return false
        if (state != other.state) return false
        if (stateChangeReason != other.stateChangeReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.SessionStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time that the session ended.
         */
        public var endDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time starting at which the session became idle. Can be empty if the session is not currently idle.
         */
        public var idleSinceDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The most recent date and time that the session was modified.
         */
        public var lastModifiedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that the session started.
         */
        public var startDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the session. A description of each state follows.
         *
         * `CREATING` - The session is being started, including acquiring resources.
         *
         * `CREATED` - The session has been started.
         *
         * `IDLE` - The session is able to accept a calculation.
         *
         * `BUSY` - The session is processing another task and is unable to accept a calculation.
         *
         * `TERMINATING` - The session is in the process of shutting down.
         *
         * `TERMINATED` - The session and its resources are no longer running.
         *
         * `DEGRADED` - The session has no healthy coordinators.
         *
         * `FAILED` - Due to a failure, the session and its resources are no longer running.
         */
        public var state: aws.sdk.kotlin.services.athena.model.SessionState? = null
        /**
         * The reason for the session state change (for example, canceled because the session was terminated).
         */
        public var stateChangeReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.SessionStatus) : this() {
            this.endDateTime = x.endDateTime
            this.idleSinceDateTime = x.idleSinceDateTime
            this.lastModifiedDateTime = x.lastModifiedDateTime
            this.startDateTime = x.startDateTime
            this.state = x.state
            this.stateChangeReason = x.stateChangeReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.SessionStatus = SessionStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
