// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Timeline statistics such as query queue time, planning time, execution time, service processing time, and total execution time.
 */
public class QueryRuntimeStatisticsTimeline private constructor(builder: Builder) {
    /**
     * The number of milliseconds that the query took to execute.
     */
    public val engineExecutionTimeInMillis: kotlin.Long? = builder.engineExecutionTimeInMillis
    /**
     * The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent retrieving table partitions from the data source. Note that because the query engine performs the query planning, query planning time is a subset of engine processing time.
     */
    public val queryPlanningTimeInMillis: kotlin.Long? = builder.queryPlanningTimeInMillis
    /**
     * The number of milliseconds that the query was in your query queue waiting for resources. Note that if transient errors occur, Athena might automatically add the query back to the queue.
     */
    public val queryQueueTimeInMillis: kotlin.Long? = builder.queryQueueTimeInMillis
    /**
     * The number of milliseconds that Athena spends on preprocessing before it submits the query to the engine.
     */
    public val servicePreProcessingTimeInMillis: kotlin.Long? = builder.servicePreProcessingTimeInMillis
    /**
     * The number of milliseconds that Athena took to finalize and publish the query results after the query engine finished running the query.
     */
    public val serviceProcessingTimeInMillis: kotlin.Long? = builder.serviceProcessingTimeInMillis
    /**
     * The number of milliseconds that Athena took to run the query.
     */
    public val totalExecutionTimeInMillis: kotlin.Long? = builder.totalExecutionTimeInMillis

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.QueryRuntimeStatisticsTimeline = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryRuntimeStatisticsTimeline(")
        append("engineExecutionTimeInMillis=$engineExecutionTimeInMillis,")
        append("queryPlanningTimeInMillis=$queryPlanningTimeInMillis,")
        append("queryQueueTimeInMillis=$queryQueueTimeInMillis,")
        append("servicePreProcessingTimeInMillis=$servicePreProcessingTimeInMillis,")
        append("serviceProcessingTimeInMillis=$serviceProcessingTimeInMillis,")
        append("totalExecutionTimeInMillis=$totalExecutionTimeInMillis")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = engineExecutionTimeInMillis?.hashCode() ?: 0
        result = 31 * result + (queryPlanningTimeInMillis?.hashCode() ?: 0)
        result = 31 * result + (queryQueueTimeInMillis?.hashCode() ?: 0)
        result = 31 * result + (servicePreProcessingTimeInMillis?.hashCode() ?: 0)
        result = 31 * result + (serviceProcessingTimeInMillis?.hashCode() ?: 0)
        result = 31 * result + (totalExecutionTimeInMillis?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryRuntimeStatisticsTimeline

        if (engineExecutionTimeInMillis != other.engineExecutionTimeInMillis) return false
        if (queryPlanningTimeInMillis != other.queryPlanningTimeInMillis) return false
        if (queryQueueTimeInMillis != other.queryQueueTimeInMillis) return false
        if (servicePreProcessingTimeInMillis != other.servicePreProcessingTimeInMillis) return false
        if (serviceProcessingTimeInMillis != other.serviceProcessingTimeInMillis) return false
        if (totalExecutionTimeInMillis != other.totalExecutionTimeInMillis) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.QueryRuntimeStatisticsTimeline = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of milliseconds that the query took to execute.
         */
        public var engineExecutionTimeInMillis: kotlin.Long? = null
        /**
         * The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent retrieving table partitions from the data source. Note that because the query engine performs the query planning, query planning time is a subset of engine processing time.
         */
        public var queryPlanningTimeInMillis: kotlin.Long? = null
        /**
         * The number of milliseconds that the query was in your query queue waiting for resources. Note that if transient errors occur, Athena might automatically add the query back to the queue.
         */
        public var queryQueueTimeInMillis: kotlin.Long? = null
        /**
         * The number of milliseconds that Athena spends on preprocessing before it submits the query to the engine.
         */
        public var servicePreProcessingTimeInMillis: kotlin.Long? = null
        /**
         * The number of milliseconds that Athena took to finalize and publish the query results after the query engine finished running the query.
         */
        public var serviceProcessingTimeInMillis: kotlin.Long? = null
        /**
         * The number of milliseconds that Athena took to run the query.
         */
        public var totalExecutionTimeInMillis: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.QueryRuntimeStatisticsTimeline) : this() {
            this.engineExecutionTimeInMillis = x.engineExecutionTimeInMillis
            this.queryPlanningTimeInMillis = x.queryPlanningTimeInMillis
            this.queryQueueTimeInMillis = x.queryQueueTimeInMillis
            this.servicePreProcessingTimeInMillis = x.servicePreProcessingTimeInMillis
            this.serviceProcessingTimeInMillis = x.serviceProcessingTimeInMillis
            this.totalExecutionTimeInMillis = x.totalExecutionTimeInMillis
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.QueryRuntimeStatisticsTimeline = QueryRuntimeStatisticsTimeline(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
