// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Specifies whether Amazon S3 access grants are enabled for query results.
 */
public class QueryResultsS3AccessGrantsConfiguration private constructor(builder: Builder) {
    /**
     * The authentication type used for Amazon S3 access grants. Currently, only `DIRECTORY_IDENTITY` is supported.
     */
    public val authenticationType: aws.sdk.kotlin.services.athena.model.AuthenticationType = requireNotNull(builder.authenticationType) { "A non-null value must be provided for authenticationType" }
    /**
     * When enabled, appends the user ID as an Amazon S3 path prefix to the query result output location.
     */
    public val createUserLevelPrefix: kotlin.Boolean? = builder.createUserLevelPrefix
    /**
     * Specifies whether Amazon S3 access grants are enabled for query results.
     */
    public val enableS3AccessGrants: kotlin.Boolean = requireNotNull(builder.enableS3AccessGrants) { "A non-null value must be provided for enableS3AccessGrants" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryResultsS3AccessGrantsConfiguration(")
        append("authenticationType=$authenticationType,")
        append("createUserLevelPrefix=$createUserLevelPrefix,")
        append("enableS3AccessGrants=$enableS3AccessGrants")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationType.hashCode()
        result = 31 * result + (createUserLevelPrefix?.hashCode() ?: 0)
        result = 31 * result + (enableS3AccessGrants.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryResultsS3AccessGrantsConfiguration

        if (authenticationType != other.authenticationType) return false
        if (createUserLevelPrefix != other.createUserLevelPrefix) return false
        if (enableS3AccessGrants != other.enableS3AccessGrants) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The authentication type used for Amazon S3 access grants. Currently, only `DIRECTORY_IDENTITY` is supported.
         */
        public var authenticationType: aws.sdk.kotlin.services.athena.model.AuthenticationType? = null
        /**
         * When enabled, appends the user ID as an Amazon S3 path prefix to the query result output location.
         */
        public var createUserLevelPrefix: kotlin.Boolean? = null
        /**
         * Specifies whether Amazon S3 access grants are enabled for query results.
         */
        public var enableS3AccessGrants: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration) : this() {
            this.authenticationType = x.authenticationType
            this.createUserLevelPrefix = x.createUserLevelPrefix
            this.enableS3AccessGrants = x.enableS3AccessGrants
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.QueryResultsS3AccessGrantsConfiguration = QueryResultsS3AccessGrantsConfiguration(this)

        internal fun correctErrors(): Builder {
            if (authenticationType == null) authenticationType = AuthenticationType.SdkUnknown("no value provided")
            if (enableS3AccessGrants == null) enableS3AccessGrants = false
            return this
        }
    }
}
