// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



public class ListExecutorsRequest private constructor(builder: Builder) {
    /**
     * A filter for a specific executor state. A description of each state follows.
     *
     * `CREATING` - The executor is being started, including acquiring resources.
     *
     * `CREATED` - The executor has been started.
     *
     * `REGISTERED` - The executor has been registered.
     *
     * `TERMINATING` - The executor is in the process of shutting down.
     *
     * `TERMINATED` - The executor is no longer running.
     *
     * `FAILED` - Due to a failure, the executor is no longer running.
     */
    public val executorStateFilter: aws.sdk.kotlin.services.athena.model.ExecutorState? = builder.executorStateFilter
    /**
     * The maximum number of executors to return.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the `NextToken` from the response object of the previous page call.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The session ID.
     */
    public val sessionId: kotlin.String? = builder.sessionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.ListExecutorsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListExecutorsRequest(")
        append("executorStateFilter=$executorStateFilter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sessionId=$sessionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = executorStateFilter?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListExecutorsRequest

        if (executorStateFilter != other.executorStateFilter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sessionId != other.sessionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.ListExecutorsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A filter for a specific executor state. A description of each state follows.
         *
         * `CREATING` - The executor is being started, including acquiring resources.
         *
         * `CREATED` - The executor has been started.
         *
         * `REGISTERED` - The executor has been registered.
         *
         * `TERMINATING` - The executor is in the process of shutting down.
         *
         * `TERMINATED` - The executor is no longer running.
         *
         * `FAILED` - Due to a failure, the executor is no longer running.
         */
        public var executorStateFilter: aws.sdk.kotlin.services.athena.model.ExecutorState? = null
        /**
         * The maximum number of executors to return.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the `NextToken` from the response object of the previous page call.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The session ID.
         */
        public var sessionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.ListExecutorsRequest) : this() {
            this.executorStateFilter = x.executorStateFilter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sessionId = x.sessionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.ListExecutorsRequest = ListExecutorsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
