// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Contains data processing unit (DPU) configuration settings and parameter mappings for a notebook engine.
 */
public class EngineConfiguration private constructor(builder: Builder) {
    /**
     * Contains additional notebook engine `MAP<string, string>` parameter mappings in the form of key-value pairs. To specify an Athena notebook that the Jupyter server will download and serve, specify a value for the StartSessionRequest$NotebookVersion field, and then add a key named `NotebookId` to `AdditionalConfigs` that has the value of the Athena notebook ID.
     */
    public val additionalConfigs: Map<String, String>? = builder.additionalConfigs
    /**
     * The number of DPUs to use for the coordinator. A coordinator is a special executor that orchestrates processing work and manages other executors in a notebook session. The default is 1.
     */
    public val coordinatorDpuSize: kotlin.Int? = builder.coordinatorDpuSize
    /**
     * The default number of DPUs to use for executors. An executor is the smallest unit of compute that a notebook session can request from Athena. The default is 1.
     */
    public val defaultExecutorDpuSize: kotlin.Int? = builder.defaultExecutorDpuSize
    /**
     * The maximum number of DPUs that can run concurrently.
     */
    public val maxConcurrentDpus: kotlin.Int = requireNotNull(builder.maxConcurrentDpus) { "A non-null value must be provided for maxConcurrentDpus" }
    /**
     * Specifies custom jar files and Spark properties for use cases like cluster encryption, table formats, and general Spark tuning.
     */
    public val sparkProperties: Map<String, String>? = builder.sparkProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.EngineConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EngineConfiguration(")
        append("additionalConfigs=$additionalConfigs,")
        append("coordinatorDpuSize=$coordinatorDpuSize,")
        append("defaultExecutorDpuSize=$defaultExecutorDpuSize,")
        append("maxConcurrentDpus=$maxConcurrentDpus,")
        append("sparkProperties=$sparkProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalConfigs?.hashCode() ?: 0
        result = 31 * result + (coordinatorDpuSize ?: 0)
        result = 31 * result + (defaultExecutorDpuSize ?: 0)
        result = 31 * result + (maxConcurrentDpus)
        result = 31 * result + (sparkProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EngineConfiguration

        if (additionalConfigs != other.additionalConfigs) return false
        if (coordinatorDpuSize != other.coordinatorDpuSize) return false
        if (defaultExecutorDpuSize != other.defaultExecutorDpuSize) return false
        if (maxConcurrentDpus != other.maxConcurrentDpus) return false
        if (sparkProperties != other.sparkProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.EngineConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains additional notebook engine `MAP<string, string>` parameter mappings in the form of key-value pairs. To specify an Athena notebook that the Jupyter server will download and serve, specify a value for the StartSessionRequest$NotebookVersion field, and then add a key named `NotebookId` to `AdditionalConfigs` that has the value of the Athena notebook ID.
         */
        public var additionalConfigs: Map<String, String>? = null
        /**
         * The number of DPUs to use for the coordinator. A coordinator is a special executor that orchestrates processing work and manages other executors in a notebook session. The default is 1.
         */
        public var coordinatorDpuSize: kotlin.Int? = null
        /**
         * The default number of DPUs to use for executors. An executor is the smallest unit of compute that a notebook session can request from Athena. The default is 1.
         */
        public var defaultExecutorDpuSize: kotlin.Int? = null
        /**
         * The maximum number of DPUs that can run concurrently.
         */
        public var maxConcurrentDpus: kotlin.Int? = null
        /**
         * Specifies custom jar files and Spark properties for use cases like cluster encryption, table formats, and general Spark tuning.
         */
        public var sparkProperties: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.EngineConfiguration) : this() {
            this.additionalConfigs = x.additionalConfigs
            this.coordinatorDpuSize = x.coordinatorDpuSize
            this.defaultExecutorDpuSize = x.defaultExecutorDpuSize
            this.maxConcurrentDpus = x.maxConcurrentDpus
            this.sparkProperties = x.sparkProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.EngineConfiguration = EngineConfiguration(this)

        internal fun correctErrors(): Builder {
            if (maxConcurrentDpus == null) maxConcurrentDpus = 0
            return this
        }
    }
}
