// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Information about the columns in a query execution result.
 */
public class ColumnInfo private constructor(builder: Builder) {
    /**
     * Indicates whether values in the column are case-sensitive.
     */
    public val caseSensitive: kotlin.Boolean = builder.caseSensitive
    /**
     * The catalog to which the query results belong.
     */
    public val catalogName: kotlin.String? = builder.catalogName
    /**
     * A column label.
     */
    public val label: kotlin.String? = builder.label
    /**
     * The name of the column.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Unsupported constraint. This value always shows as `UNKNOWN`.
     */
    public val nullable: aws.sdk.kotlin.services.athena.model.ColumnNullable? = builder.nullable
    /**
     * For `DECIMAL` data types, specifies the total number of digits, up to 38. For performance reasons, we recommend up to 18 digits.
     */
    public val precision: kotlin.Int = builder.precision
    /**
     * For `DECIMAL` data types, specifies the total number of digits in the fractional part of the value. Defaults to 0.
     */
    public val scale: kotlin.Int = builder.scale
    /**
     * The schema name (database name) to which the query results belong.
     */
    public val schemaName: kotlin.String? = builder.schemaName
    /**
     * The table name for the query results.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * The data type of the column.
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.ColumnInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ColumnInfo(")
        append("caseSensitive=$caseSensitive,")
        append("catalogName=$catalogName,")
        append("label=$label,")
        append("name=$name,")
        append("nullable=$nullable,")
        append("precision=$precision,")
        append("scale=$scale,")
        append("schemaName=$schemaName,")
        append("tableName=$tableName,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = caseSensitive.hashCode()
        result = 31 * result + (catalogName?.hashCode() ?: 0)
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (nullable?.hashCode() ?: 0)
        result = 31 * result + (precision)
        result = 31 * result + (scale)
        result = 31 * result + (schemaName?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ColumnInfo

        if (caseSensitive != other.caseSensitive) return false
        if (catalogName != other.catalogName) return false
        if (label != other.label) return false
        if (name != other.name) return false
        if (nullable != other.nullable) return false
        if (precision != other.precision) return false
        if (scale != other.scale) return false
        if (schemaName != other.schemaName) return false
        if (tableName != other.tableName) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.ColumnInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether values in the column are case-sensitive.
         */
        public var caseSensitive: kotlin.Boolean = false
        /**
         * The catalog to which the query results belong.
         */
        public var catalogName: kotlin.String? = null
        /**
         * A column label.
         */
        public var label: kotlin.String? = null
        /**
         * The name of the column.
         */
        public var name: kotlin.String? = null
        /**
         * Unsupported constraint. This value always shows as `UNKNOWN`.
         */
        public var nullable: aws.sdk.kotlin.services.athena.model.ColumnNullable? = null
        /**
         * For `DECIMAL` data types, specifies the total number of digits, up to 38. For performance reasons, we recommend up to 18 digits.
         */
        public var precision: kotlin.Int = 0
        /**
         * For `DECIMAL` data types, specifies the total number of digits in the fractional part of the value. Defaults to 0.
         */
        public var scale: kotlin.Int = 0
        /**
         * The schema name (database name) to which the query results belong.
         */
        public var schemaName: kotlin.String? = null
        /**
         * The table name for the query results.
         */
        public var tableName: kotlin.String? = null
        /**
         * The data type of the column.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.ColumnInfo) : this() {
            this.caseSensitive = x.caseSensitive
            this.catalogName = x.catalogName
            this.label = x.label
            this.name = x.name
            this.nullable = x.nullable
            this.precision = x.precision
            this.scale = x.scale
            this.schemaName = x.schemaName
            this.tableName = x.tableName
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.ColumnInfo = ColumnInfo(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (type == null) type = ""
            return this
        }
    }
}
