// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A reservation for a specified number of data processing units (DPUs). When a reservation is initially created, it has no DPUs. Athena allocates DPUs until the allocated amount equals the requested amount.
 */
public class CapacityReservation private constructor(builder: Builder) {
    /**
     * The number of data processing units currently allocated.
     */
    public val allocatedDpus: kotlin.Int = requireNotNull(builder.allocatedDpus) { "A non-null value must be provided for allocatedDpus" }
    /**
     * The time in UTC epoch millis when the capacity reservation was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * Contains the submission time of a single allocation request for a capacity reservation and the most recent status of the attempted allocation.
     */
    public val lastAllocation: aws.sdk.kotlin.services.athena.model.CapacityAllocation? = builder.lastAllocation
    /**
     * The time of the most recent capacity allocation that succeeded.
     */
    public val lastSuccessfulAllocationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulAllocationTime
    /**
     * The name of the capacity reservation.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the capacity reservation.
     */
    public val status: aws.sdk.kotlin.services.athena.model.CapacityReservationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The number of data processing units requested.
     */
    public val targetDpus: kotlin.Int = requireNotNull(builder.targetDpus) { "A non-null value must be provided for targetDpus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.CapacityReservation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityReservation(")
        append("allocatedDpus=$allocatedDpus,")
        append("creationTime=$creationTime,")
        append("lastAllocation=$lastAllocation,")
        append("lastSuccessfulAllocationTime=$lastSuccessfulAllocationTime,")
        append("name=$name,")
        append("status=$status,")
        append("targetDpus=$targetDpus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedDpus
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (lastAllocation?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulAllocationTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (targetDpus)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityReservation

        if (allocatedDpus != other.allocatedDpus) return false
        if (creationTime != other.creationTime) return false
        if (lastAllocation != other.lastAllocation) return false
        if (lastSuccessfulAllocationTime != other.lastSuccessfulAllocationTime) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (targetDpus != other.targetDpus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.CapacityReservation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of data processing units currently allocated.
         */
        public var allocatedDpus: kotlin.Int? = null
        /**
         * The time in UTC epoch millis when the capacity reservation was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains the submission time of a single allocation request for a capacity reservation and the most recent status of the attempted allocation.
         */
        public var lastAllocation: aws.sdk.kotlin.services.athena.model.CapacityAllocation? = null
        /**
         * The time of the most recent capacity allocation that succeeded.
         */
        public var lastSuccessfulAllocationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the capacity reservation.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the capacity reservation.
         */
        public var status: aws.sdk.kotlin.services.athena.model.CapacityReservationStatus? = null
        /**
         * The number of data processing units requested.
         */
        public var targetDpus: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.CapacityReservation) : this() {
            this.allocatedDpus = x.allocatedDpus
            this.creationTime = x.creationTime
            this.lastAllocation = x.lastAllocation
            this.lastSuccessfulAllocationTime = x.lastSuccessfulAllocationTime
            this.name = x.name
            this.status = x.status
            this.targetDpus = x.targetDpus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.CapacityReservation = CapacityReservation(this)

        /**
         * construct an [aws.sdk.kotlin.services.athena.model.CapacityAllocation] inside the given [block]
         */
        public fun lastAllocation(block: aws.sdk.kotlin.services.athena.model.CapacityAllocation.Builder.() -> kotlin.Unit) {
            this.lastAllocation = aws.sdk.kotlin.services.athena.model.CapacityAllocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (allocatedDpus == null) allocatedDpus = 0
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (status == null) status = CapacityReservationStatus.SdkUnknown("no value provided")
            if (targetDpus == null) targetDpus = 0
            return this
        }
    }
}
