// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model



/**
 * Assigns Athena workgroups (and hence their queries) to capacity reservations. A capacity reservation can have only one capacity assignment configuration, but the capacity assignment configuration can be made up of multiple individual assignments. Each assignment specifies how Athena queries can consume capacity from the capacity reservation that their workgroup is mapped to.
 */
public class CapacityAssignmentConfiguration private constructor(builder: Builder) {
    /**
     * The list of assignments that make up the capacity assignment configuration.
     */
    public val capacityAssignments: List<CapacityAssignment>? = builder.capacityAssignments
    /**
     * The name of the reservation that the capacity assignment configuration is for.
     */
    public val capacityReservationName: kotlin.String? = builder.capacityReservationName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.CapacityAssignmentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityAssignmentConfiguration(")
        append("capacityAssignments=$capacityAssignments,")
        append("capacityReservationName=$capacityReservationName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityAssignments?.hashCode() ?: 0
        result = 31 * result + (capacityReservationName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityAssignmentConfiguration

        if (capacityAssignments != other.capacityAssignments) return false
        if (capacityReservationName != other.capacityReservationName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.CapacityAssignmentConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of assignments that make up the capacity assignment configuration.
         */
        public var capacityAssignments: List<CapacityAssignment>? = null
        /**
         * The name of the reservation that the capacity assignment configuration is for.
         */
        public var capacityReservationName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.CapacityAssignmentConfiguration) : this() {
            this.capacityAssignments = x.capacityAssignments
            this.capacityReservationName = x.capacityReservationName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.CapacityAssignmentConfiguration = CapacityAssignmentConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
