// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the submission time of a single allocation request for a capacity reservation and the most recent status of the attempted allocation.
 */
public class CapacityAllocation private constructor(builder: Builder) {
    /**
     * The time when the capacity allocation request was completed.
     */
    public val requestCompletionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestCompletionTime
    /**
     * The time when the capacity allocation was requested.
     */
    public val requestTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.requestTime) { "A non-null value must be provided for requestTime" }
    /**
     * The status of the capacity allocation.
     */
    public val status: aws.sdk.kotlin.services.athena.model.CapacityAllocationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The status message of the capacity allocation.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.CapacityAllocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityAllocation(")
        append("requestCompletionTime=$requestCompletionTime,")
        append("requestTime=$requestTime,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = requestCompletionTime?.hashCode() ?: 0
        result = 31 * result + (requestTime.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityAllocation

        if (requestCompletionTime != other.requestCompletionTime) return false
        if (requestTime != other.requestTime) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.CapacityAllocation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the capacity allocation request was completed.
         */
        public var requestCompletionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the capacity allocation was requested.
         */
        public var requestTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the capacity allocation.
         */
        public var status: aws.sdk.kotlin.services.athena.model.CapacityAllocationStatus? = null
        /**
         * The status message of the capacity allocation.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.CapacityAllocation) : this() {
            this.requestCompletionTime = x.requestCompletionTime
            this.requestTime = x.requestTime
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.CapacityAllocation = CapacityAllocation(this)

        internal fun correctErrors(): Builder {
            if (requestTime == null) requestTime = Instant.fromEpochSeconds(0)
            if (status == null) status = CapacityAllocationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
