// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.athena.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the status of a notebook calculation.
 */
public class CalculationStatus private constructor(builder: Builder) {
    /**
     * The date and time the calculation completed processing.
     */
    public val completionDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionDateTime
    /**
     * The state of the calculation execution. A description of each state follows.
     *
     * `CREATING` - The calculation is in the process of being created.
     *
     * `CREATED` - The calculation has been created and is ready to run.
     *
     * `QUEUED` - The calculation has been queued for processing.
     *
     * `RUNNING` - The calculation is running.
     *
     * `CANCELING` - A request to cancel the calculation has been received and the system is working to stop it.
     *
     * `CANCELED` - The calculation is no longer running as the result of a cancel request.
     *
     * `COMPLETED` - The calculation has completed without error.
     *
     * `FAILED` - The calculation failed and is no longer running.
     */
    public val state: aws.sdk.kotlin.services.athena.model.CalculationExecutionState? = builder.state
    /**
     * The reason for the calculation state change (for example, the calculation was canceled because the session was terminated).
     */
    public val stateChangeReason: kotlin.String? = builder.stateChangeReason
    /**
     * The date and time the calculation was submitted for processing.
     */
    public val submissionDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submissionDateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.athena.model.CalculationStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CalculationStatus(")
        append("completionDateTime=$completionDateTime,")
        append("state=$state,")
        append("stateChangeReason=$stateChangeReason,")
        append("submissionDateTime=$submissionDateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionDateTime?.hashCode() ?: 0
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateChangeReason?.hashCode() ?: 0)
        result = 31 * result + (submissionDateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CalculationStatus

        if (completionDateTime != other.completionDateTime) return false
        if (state != other.state) return false
        if (stateChangeReason != other.stateChangeReason) return false
        if (submissionDateTime != other.submissionDateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.athena.model.CalculationStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time the calculation completed processing.
         */
        public var completionDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the calculation execution. A description of each state follows.
         *
         * `CREATING` - The calculation is in the process of being created.
         *
         * `CREATED` - The calculation has been created and is ready to run.
         *
         * `QUEUED` - The calculation has been queued for processing.
         *
         * `RUNNING` - The calculation is running.
         *
         * `CANCELING` - A request to cancel the calculation has been received and the system is working to stop it.
         *
         * `CANCELED` - The calculation is no longer running as the result of a cancel request.
         *
         * `COMPLETED` - The calculation has completed without error.
         *
         * `FAILED` - The calculation failed and is no longer running.
         */
        public var state: aws.sdk.kotlin.services.athena.model.CalculationExecutionState? = null
        /**
         * The reason for the calculation state change (for example, the calculation was canceled because the session was terminated).
         */
        public var stateChangeReason: kotlin.String? = null
        /**
         * The date and time the calculation was submitted for processing.
         */
        public var submissionDateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.athena.model.CalculationStatus) : this() {
            this.completionDateTime = x.completionDateTime
            this.state = x.state
            this.stateChangeReason = x.stateChangeReason
            this.submissionDateTime = x.submissionDateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.athena.model.CalculationStatus = CalculationStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
